/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class FileUtils {
    private static final String STRUCTURIZR_DSL_FILE_EXTENSION = ".dsl";

    FileUtils() {
    }

    static List<File> findFiles(File path) {
        ArrayList<File> files = new ArrayList<File>();
        if (path.isDirectory()) {
            files = FileUtils.findFilesInDirectory(path);
        } else {
            files.add(path);
        }
        return files;
    }

    private static List<File> findFilesInDirectory(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        Object[] filesInDirectory = directory.listFiles();
        if (filesInDirectory == null || filesInDirectory.length == 0) {
            return files;
        }
        Arrays.sort(filesInDirectory);
        for (Object file : filesInDirectory) {
            if (!((File)file).isDirectory() && ((File)file).getName().endsWith(STRUCTURIZR_DSL_FILE_EXTENSION)) {
                files.add((File)file);
            }
            if (!((File)file).isDirectory()) continue;
            files.addAll(FileUtils.findFilesInDirectory((File)file));
        }
        return files;
    }
}

