/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.StaticStructureElementInstanceDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.StaticStructureElementInstance;

class HealthCheckParser
extends AbstractParser {
    private static final String GRAMMAR = "healthCheck <name> <url> [interval] [timeout]";
    private static final int NAME_INDEX = 1;
    private static final int URL_INDEX = 2;
    private static final int INTERVAL_INDEX = 3;
    private static final int TIMEOUT_INDEX = 4;
    private static final int DEFAULT_INTERVAL = 60;
    private static final long DEFAULT_TIMEOUT = 0L;

    HealthCheckParser() {
    }

    void parse(StaticStructureElementInstanceDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: healthCheck <name> <url> [interval] [timeout]");
        }
        if (!tokens.includes(2)) {
            throw new RuntimeException("Expected: healthCheck <name> <url> [interval] [timeout]");
        }
        String name = tokens.get(1);
        String url = tokens.get(2);
        int interval = 60;
        long timeout = 0L;
        if (tokens.includes(3)) {
            try {
                interval = Integer.parseInt(tokens.get(3));
                if (interval < 1) {
                    throw new RuntimeException("The interval must be a positive integer (number of seconds)");
                }
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("The interval of \"" + tokens.get(3) + "\" is not valid - it must be a positive integer (number of seconds)");
            }
        }
        if (tokens.includes(4)) {
            try {
                timeout = Integer.parseInt(tokens.get(4));
                if (timeout < 0L) {
                    throw new RuntimeException("The timeout must be zero or a positive integer (number of milliseconds)");
                }
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("The timeout of \"" + tokens.get(4) + "\" is not valid - it must be zero or a positive integer (number of milliseconds)");
            }
        }
        StaticStructureElementInstance elementInstance = context.getElementInstance();
        elementInstance.addHealthCheck(name, url, interval, timeout);
    }
}

