/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractRelationshipParser;
import com.structurizr.dsl.ModelItemDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;

final class ImplicitRelationshipParser
extends AbstractRelationshipParser {
    private static final String GRAMMAR = "-> <identifier> [description] [technology] [tags]";
    private static final int DESTINATION_IDENTIFIER_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TECHNOLOGY_INDEX = 3;
    private static final int TAGS_INDEX = 4;

    ImplicitRelationshipParser() {
    }

    Relationship parse(ModelItemDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: -> <identifier> [description] [technology] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: -> <identifier> [description] [technology] [tags]");
        }
        String destinationId = tokens.get(1);
        Element sourceElement = (Element)context.getModelItem();
        Element destinationElement = context.getElement(destinationId);
        if (destinationElement == null) {
            throw new RuntimeException("The destination element \"" + destinationId + "\" does not exist");
        }
        String description = "";
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        String technology = "";
        if (tokens.includes(3)) {
            technology = tokens.get(3);
        }
        String[] tags = new String[]{};
        if (tokens.includes(4)) {
            tags = tokens.get(4).split(",");
        }
        return this.createRelationship(sourceElement, description, technology, tags, destinationElement);
    }
}

