/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.IncludedDslContext;
import com.structurizr.dsl.Tokens;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;

final class IncludeParser
extends AbstractParser {
    private static final String GRAMMAR = "!include <file|url>";
    private static final int FILE_INDEX = 1;

    IncludeParser() {
    }

    void parse(IncludedDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: !include <file|url>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: !include <file|url>");
        }
        String source = tokens.get(1);
        if (source.startsWith("https://")) {
            String dsl = this.readFromUrl(source);
            List<String> lines = Arrays.asList(dsl.split("\n"));
            context.setLines(lines);
            context.setFile(context.getFile());
        } else if (context.getParentFile() != null) {
            File file = new File(context.getParentFile().getParent(), source);
            try {
                if (!file.exists()) {
                    throw new RuntimeException(file.getCanonicalPath() + " could not be found");
                }
                if (file.isDirectory()) {
                    throw new RuntimeException(file.getCanonicalPath() + " should be a single file");
                }
                List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
                context.setLines(lines);
                context.setFile(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

