/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.InfrastructureNode;

final class InfrastructureNodeParser
extends AbstractParser {
    private static final String GRAMMAR = "infrastructureNode <name> [description] [technology] [tags]";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TECHNOLOGY_INDEX = 3;
    private static final int TAGS_INDEX = 4;

    InfrastructureNodeParser() {
    }

    InfrastructureNode parse(DeploymentNodeDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: infrastructureNode <name> [description] [technology] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: infrastructureNode <name> [description] [technology] [tags]");
        }
        DeploymentNode deploymentNode = context.getDeploymentNode();
        String name = tokens.get(1);
        String description = "";
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        String technology = "";
        if (tokens.includes(3)) {
            technology = tokens.get(3);
        }
        InfrastructureNode infrastructureNode = deploymentNode.addInfrastructureNode(name, description, technology);
        if (tokens.includes(4)) {
            String tags = tokens.get(4);
            infrastructureNode.addTags(tags.split(","));
        }
        return infrastructureNode;
    }
}

