/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.ScriptDslContext;
import java.util.ArrayList;
import java.util.List;

class InlineScriptDslContext
extends ScriptDslContext {
    private String language;
    private List<String> lines = new ArrayList<String>();

    InlineScriptDslContext(String language) {
        this.language = language;
    }

    void addLine(String line) {
        this.lines.add(line);
    }

    @Override
    void end() {
        try {
            String fileExtension;
            switch (this.language.toLowerCase()) {
                case "javascript": {
                    fileExtension = "js";
                    break;
                }
                case "groovy": {
                    fileExtension = "groovy";
                    break;
                }
                case "kotlin": {
                    fileExtension = "kts";
                    break;
                }
                case "ruby": {
                    fileExtension = "rb";
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported scripting language \"" + this.language + "\"");
                }
            }
            this.run(this, fileExtension, this.lines);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error running inline script, caused by " + e.getClass().getName() + ": " + e.getMessage());
        }
    }
}

