/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.StructurizrDslPlugin;
import com.structurizr.dsl.StructurizrDslPluginContext;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

class PluginDslContext
extends DslContext {
    private String fullyQualifiedClassName;
    private File pluginsDirectory;
    private Map<String, String> parameters = new HashMap<String, String>();

    PluginDslContext(String fullyQualifiedClassName, File scriptDirectory) {
        this.fullyQualifiedClassName = fullyQualifiedClassName;
        this.pluginsDirectory = new File(scriptDirectory, "plugins");
    }

    void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    void end() {
        String fqn = this.fullyQualifiedClassName;
        try {
            URL[] urls;
            if (!this.pluginsDirectory.exists()) {
                throw new RuntimeException("No plugins directory found");
            }
            File[] jarFiles = this.pluginsDirectory.listFiles((dir, name) -> name.endsWith(".jar"));
            if (jarFiles != null) {
                urls = new URL[jarFiles.length];
                for (int i = 0; i < jarFiles.length; ++i) {
                    try {
                        urls[i] = jarFiles[i].toURI().toURL();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                throw new RuntimeException("No JAR files found in " + this.pluginsDirectory.getCanonicalPath());
            }
            URLClassLoader childClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
            StructurizrDslPlugin plugin = (StructurizrDslPlugin)Class.forName(fqn, true, childClassLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            StructurizrDslPluginContext pluginContext = new StructurizrDslPluginContext(this.getWorkspace(), this.parameters);
            plugin.run(pluginContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error running plugin " + fqn + ", caused by " + e.getClass().getName() + ": " + e.getMessage());
        }
    }
}

