/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;

final class ThemeParser
extends AbstractParser {
    private static final String DEFAULT_THEME_URL = "https://static.structurizr.com/themes/default/theme.json";
    private static final int FIRST_THEME_INDEX = 1;

    ThemeParser() {
    }

    void parseTheme(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: theme <url>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: theme <url>");
        }
        this.addTheme(context, tokens.get(1));
    }

    void parseThemes(DslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: themes <url> [url] ... [url]");
        }
        for (int i = 1; i < tokens.size(); ++i) {
            this.addTheme(context, tokens.get(i));
        }
    }

    private void addTheme(DslContext context, String url) {
        if ("default".equalsIgnoreCase(url)) {
            url = DEFAULT_THEME_URL;
        }
        context.getWorkspace().getViews().getConfiguration().addTheme(url);
    }
}

