/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import java.util.ArrayList;
import java.util.List;

class Tokenizer {
    Tokenizer() {
    }

    List<String> tokenize(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        line = line.trim();
        boolean tokenStarted = false;
        boolean quoted = false;
        StringBuilder token = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (!tokenStarted) {
                if (c == '\"') {
                    quoted = true;
                    tokenStarted = true;
                    token = new StringBuilder();
                    continue;
                }
                if (c == ' ') continue;
                quoted = false;
                tokenStarted = true;
                token = new StringBuilder();
                token.append(c);
                continue;
            }
            if (c == '\"' && line.charAt(i - 1) == '\\') {
                token.append(c);
                continue;
            }
            if (quoted && c == '\"') {
                tokens.add(token.toString());
                tokenStarted = false;
                quoted = false;
                continue;
            }
            if (!quoted && c == ' ') {
                tokens.add(token.toString());
                tokenStarted = false;
                quoted = false;
                continue;
            }
            token.append(c);
        }
        if (tokenStarted) {
            tokens.add(token.toString());
        }
        return tokens;
    }
}

