/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.ElementGroup;
import com.structurizr.model.Element;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Relationship;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractExpressionParser {
    private static final String WILDCARD = "*";

    AbstractExpressionParser() {
    }

    static boolean isExpression(String token) {
        return (token = token.toLowerCase()).startsWith("element.type==".toLowerCase()) || token.startsWith("element.tag==".toLowerCase()) || token.startsWith("element.tag!=".toLowerCase()) || token.startsWith("element.parent==".toLowerCase()) || token.startsWith("->") || token.endsWith("->") || token.contains("->") || token.startsWith("element==") || token.startsWith("relationship.tag==".toLowerCase()) || token.startsWith("relationship.tag!=".toLowerCase()) || token.startsWith("relationship.source==".toLowerCase()) || token.startsWith("relationship.destination==".toLowerCase()) || token.startsWith("relationship==");
    }

    final Set<ModelItem> parseExpression(String expr, DslContext context) {
        if (expr.contains(" && ")) {
            String[] expressions = expr.split(" && ");
            Set<ModelItem> modelItems1 = this.evaluateExpression(expressions[0], context);
            Set<ModelItem> modelItems2 = this.evaluateExpression(expressions[1], context);
            HashSet<ModelItem> modelItems = new HashSet<ModelItem>(modelItems1);
            modelItems.retainAll(modelItems2);
            return modelItems;
        }
        if (expr.contains(" || ")) {
            String[] expressions = expr.split(" \\|\\| ");
            Set<ModelItem> modelItems1 = this.evaluateExpression(expressions[0], context);
            Set<ModelItem> modelItems2 = this.evaluateExpression(expressions[1], context);
            HashSet<ModelItem> elements = new HashSet<ModelItem>(modelItems1);
            elements.addAll(modelItems2);
            return elements;
        }
        return this.evaluateExpression(expr, context);
    }

    private Set<ModelItem> evaluateExpression(String expr, DslContext context) {
        LinkedHashSet<ModelItem> modelItems = new LinkedHashSet<ModelItem>();
        if (expr.startsWith("element==")) {
            if (AbstractExpressionParser.isExpression(expr = expr.substring("element==".length()))) {
                modelItems.addAll(this.evaluateExpression(expr, context));
            } else {
                modelItems.addAll(this.parseIdentifier(expr, context));
            }
        } else if (expr.startsWith("relationship==")) {
            if (WILDCARD.equals(expr = expr.substring("relationship==".length()))) {
                expr = "*->*";
            }
            if (AbstractExpressionParser.isExpression(expr)) {
                modelItems.addAll(this.evaluateExpression(expr, context));
            } else {
                modelItems.addAll(this.parseIdentifier(expr, context));
            }
        } else {
            if ("->".equals(expr)) {
                throw new RuntimeException("Unexpected identifier \"->\"");
            }
            if (expr.startsWith("->") || expr.endsWith("->")) {
                Set<Object> elements;
                boolean includeAfferentCouplings = false;
                boolean includeEfferentCouplings = false;
                String identifier = expr;
                if (identifier.startsWith("->")) {
                    includeAfferentCouplings = true;
                    identifier = identifier.substring("->".length());
                }
                if (identifier.endsWith("->")) {
                    includeEfferentCouplings = true;
                    identifier = identifier.substring(0, identifier.length() - "->".length());
                }
                if ((elements = AbstractExpressionParser.isExpression(identifier = identifier.trim()) ? this.parseExpression(identifier, context).stream().filter(mi -> mi instanceof Element).map(mi -> (Element)mi).collect(Collectors.toSet()) : this.getElements(identifier, context)).isEmpty()) {
                    throw new RuntimeException("The element \"" + identifier + "\" does not exist");
                }
                for (Element element2 : elements) {
                    modelItems.add((ModelItem)element2);
                    if (includeAfferentCouplings) {
                        modelItems.addAll(this.findAfferentCouplings(element2));
                    }
                    if (!includeEfferentCouplings) continue;
                    modelItems.addAll(this.findEfferentCouplings(element2));
                }
            } else if (expr.contains("->")) {
                String[] identifiers = expr.split("->");
                String sourceIdentifier = identifiers[0].trim();
                String destinationIdentifier = identifiers[1].trim();
                String sourceExpression = "relationship.source==" + sourceIdentifier;
                String destinationExpression = "relationship.destination==" + destinationIdentifier;
                if (WILDCARD.equals(sourceIdentifier) && WILDCARD.equals(destinationIdentifier)) {
                    modelItems.addAll(context.getWorkspace().getModel().getRelationships());
                } else if (WILDCARD.equals(destinationIdentifier)) {
                    modelItems.addAll(this.parseExpression(sourceExpression, context));
                } else if (WILDCARD.equals(sourceIdentifier)) {
                    modelItems.addAll(this.parseExpression(destinationExpression, context));
                } else {
                    modelItems.addAll(this.parseExpression(sourceExpression + " && " + destinationExpression, context));
                }
            } else if (expr.toLowerCase().startsWith("element.parent==")) {
                String parentIdentifier = expr.substring("element.parent==".length());
                Element parentElement = context.getElement(parentIdentifier);
                if (parentElement == null) {
                    throw new RuntimeException("The parent element \"" + parentIdentifier + "\" does not exist");
                }
                context.getWorkspace().getModel().getElements().forEach(element -> {
                    if (element.getParent() == parentElement) {
                        modelItems.add((ModelItem)element);
                    }
                });
            } else if (expr.toLowerCase().startsWith("element.type==")) {
                modelItems.addAll(this.evaluateElementTypeExpression(expr, context));
            } else if (expr.toLowerCase().startsWith("element.tag==".toLowerCase())) {
                String[] tags = expr.substring("element.tag==".length()).split(",");
                context.getWorkspace().getModel().getElements().forEach(element -> {
                    if (this.hasAllTags((ModelItem)element, tags)) {
                        modelItems.add((ModelItem)element);
                    }
                });
            } else if (expr.toLowerCase().startsWith("element.tag!=")) {
                String[] tags = expr.substring("element.tag!=".length()).split(",");
                context.getWorkspace().getModel().getElements().forEach(element -> {
                    if (!this.hasAllTags((ModelItem)element, tags)) {
                        modelItems.add((ModelItem)element);
                    }
                });
            } else if (expr.startsWith("relationship.tag==")) {
                String[] tags = expr.substring("relationship.tag==".length()).split(",");
                context.getWorkspace().getModel().getRelationships().forEach(relationship -> {
                    if (this.hasAllTags((ModelItem)relationship, tags)) {
                        modelItems.add((ModelItem)relationship);
                    }
                });
            } else if (expr.startsWith("relationship.tag!=")) {
                String[] tags = expr.substring("relationship.tag!=".length()).split(",");
                context.getWorkspace().getModel().getRelationships().forEach(relationship -> {
                    if (!this.hasAllTags((ModelItem)relationship, tags)) {
                        modelItems.add((ModelItem)relationship);
                    }
                });
            } else if (expr.startsWith("relationship.source==")) {
                String identifier = expr.substring("relationship.source==".length());
                HashSet<Element> sourceElements = new HashSet<Element>();
                if (AbstractExpressionParser.isExpression(identifier)) {
                    Set<ModelItem> set = this.parseExpression(identifier, context);
                    for (ModelItem modelItem : set) {
                        if (!(modelItem instanceof Element)) continue;
                        sourceElements.add((Element)modelItem);
                    }
                } else {
                    Element source = context.getElement(identifier);
                    if (source == null) {
                        throw new RuntimeException("The element \"" + identifier + "\" does not exist");
                    }
                    if (source instanceof ElementGroup) {
                        sourceElements.addAll(((ElementGroup)source).getElements());
                    } else {
                        sourceElements.add(source);
                    }
                }
                context.getWorkspace().getModel().getRelationships().forEach(relationship -> {
                    if (sourceElements.contains(relationship.getSource())) {
                        modelItems.add((ModelItem)relationship);
                    }
                });
            } else if (expr.startsWith("relationship.destination==")) {
                String identifier = expr.substring("relationship.destination==".length());
                HashSet<Element> destinationElements = new HashSet<Element>();
                if (AbstractExpressionParser.isExpression(identifier)) {
                    Set<ModelItem> set = this.parseExpression(identifier, context);
                    for (ModelItem modelItem : set) {
                        if (!(modelItem instanceof Element)) continue;
                        destinationElements.add((Element)modelItem);
                    }
                } else {
                    Element destination = context.getElement(identifier);
                    if (destination == null) {
                        throw new RuntimeException("The element \"" + identifier + "\" does not exist");
                    }
                    if (destination instanceof ElementGroup) {
                        destinationElements.addAll(((ElementGroup)destination).getElements());
                    } else {
                        destinationElements.add(destination);
                    }
                }
                context.getWorkspace().getModel().getRelationships().forEach(relationship -> {
                    if (destinationElements.contains(relationship.getDestination())) {
                        modelItems.add((ModelItem)relationship);
                    }
                });
            }
        }
        return modelItems;
    }

    protected abstract Set<Element> evaluateElementTypeExpression(String var1, DslContext var2);

    private boolean hasAllTags(ModelItem modelItem, String[] tags) {
        boolean result = true;
        for (String tag : tags) {
            boolean hasTag = modelItem.hasTag(tag.trim());
            if (!hasTag) {
                Relationship linkedRelationship;
                Relationship relationship;
                if (modelItem instanceof StaticStructureElementInstance) {
                    StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)modelItem;
                    hasTag = elementInstance.getElement().hasTag(tag.trim());
                } else if (modelItem instanceof Relationship && !StringUtils.isNullOrEmpty((String)(relationship = (Relationship)modelItem).getLinkedRelationshipId()) && (linkedRelationship = relationship.getModel().getRelationship(relationship.getLinkedRelationshipId())) != null) {
                    hasTag = linkedRelationship.hasTag(tag.trim());
                }
            }
            result = result && hasTag;
        }
        return result;
    }

    protected abstract Set<Element> findAfferentCouplings(Element var1);

    protected <T extends Element> Set<Element> findAfferentCouplings(Element element, Class<T> typeOfElement) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        Set relationships = element.getModel().getRelationships();
        relationships.stream().filter(r -> r.getDestination().equals(element) && typeOfElement.isInstance(r.getSource())).map(Relationship::getSource).forEach(elements::add);
        return elements;
    }

    protected abstract Set<Element> findEfferentCouplings(Element var1);

    protected <T extends Element> Set<Element> findEfferentCouplings(Element element, Class<T> typeOfElement) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        Set relationships = element.getModel().getRelationships();
        relationships.stream().filter(r -> r.getSource().equals(element) && typeOfElement.isInstance(r.getDestination())).map(Relationship::getDestination).forEach(elements::add);
        return elements;
    }

    protected Set<ModelItem> parseIdentifier(String identifier, DslContext context) {
        Relationship relationship;
        LinkedHashSet<ModelItem> modelItems = new LinkedHashSet<ModelItem>();
        Element element = context.getElement(identifier);
        if (element != null) {
            modelItems.addAll(this.getElements(identifier, context));
        }
        if ((relationship = context.getRelationship(identifier)) != null) {
            modelItems.add((ModelItem)relationship);
        }
        if (modelItems.isEmpty()) {
            throw new RuntimeException("The element/relationship \"" + identifier + "\" does not exist");
        }
        return modelItems;
    }

    private Set<Element> getElements(String identifier, DslContext context) {
        HashSet<Element> elements = new HashSet<Element>();
        Element element = context.getElement(identifier);
        if (element != null) {
            if (element instanceof ElementGroup) {
                ElementGroup group = (ElementGroup)element;
                elements.addAll(group.getElements());
            } else {
                elements.add(element);
            }
        }
        return elements;
    }
}

