/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Relationship;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.model.StaticStructureElementInstance;

abstract class AbstractRelationshipParser
extends AbstractParser {
    AbstractRelationshipParser() {
    }

    protected Relationship createRelationship(Element sourceElement, String description, String technology, String[] tags, Element destinationElement) {
        Relationship relationship = null;
        if (sourceElement instanceof CustomElement) {
            relationship = ((CustomElement)sourceElement).uses(destinationElement, description, technology, null, tags);
        } else if (destinationElement instanceof CustomElement) {
            relationship = sourceElement.uses((CustomElement)destinationElement, description, technology, null, tags);
        } else if (sourceElement instanceof StaticStructureElement && destinationElement instanceof StaticStructureElement) {
            relationship = ((StaticStructureElement)sourceElement).uses((StaticStructureElement)destinationElement, description, technology, null, tags);
        } else if (sourceElement instanceof DeploymentNode && destinationElement instanceof DeploymentNode) {
            relationship = ((DeploymentNode)sourceElement).uses((DeploymentNode)destinationElement, description, technology, null, tags);
        } else if (sourceElement instanceof DeploymentNode && destinationElement instanceof InfrastructureNode) {
            relationship = ((DeploymentNode)sourceElement).uses((InfrastructureNode)destinationElement, description, technology, null, tags);
        } else if (sourceElement instanceof InfrastructureNode && destinationElement instanceof DeploymentElement) {
            relationship = ((InfrastructureNode)sourceElement).uses((DeploymentElement)destinationElement, description, technology, null, tags);
        } else if (sourceElement instanceof StaticStructureElementInstance && destinationElement instanceof InfrastructureNode) {
            relationship = ((StaticStructureElementInstance)sourceElement).uses((InfrastructureNode)destinationElement, description, technology, null, tags);
        } else {
            throw new RuntimeException("A relationship between \"" + sourceElement.getCanonicalName() + "\" and \"" + destinationElement.getCanonicalName() + "\" is not permitted");
        }
        return relationship;
    }
}

