/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.CustomViewDslContext;
import com.structurizr.dsl.CustomViewExpressionParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.dsl.ViewContentParser;
import com.structurizr.model.CustomElement;
import com.structurizr.model.Element;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Relationship;
import com.structurizr.util.StringUtils;
import com.structurizr.view.CustomView;
import com.structurizr.view.ElementNotPermittedInViewException;
import com.structurizr.view.View;

final class CustomViewContentParser
extends ViewContentParser {
    private static final int FIRST_IDENTIFIER_INDEX = 1;

    CustomViewContentParser() {
    }

    void parseInclude(CustomViewDslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: include <*|identifier> [*|identifier...]");
        }
        CustomView view = context.getCustomView();
        for (int i = 1; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (token.equals("*") || token.equals("element==*")) {
                view.addDefaultElements();
                continue;
            }
            if (this.isExpression(token)) {
                new CustomViewExpressionParser().parseExpression(token, context).forEach(mi -> this.addModelItemToView((ModelItem)mi, view, null));
                continue;
            }
            new CustomViewExpressionParser().parseIdentifier(token, context).forEach(mi -> this.addModelItemToView((ModelItem)mi, view, token));
        }
    }

    void parseExclude(CustomViewDslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: exclude <identifier> [identifier...]");
        }
        CustomView view = context.getCustomView();
        for (int i = 1; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (this.isExpression(token)) {
                new CustomViewExpressionParser().parseExpression(token, context).forEach(mi -> this.removeModelItemFromView((ModelItem)mi, view));
                continue;
            }
            new CustomViewExpressionParser().parseIdentifier(token, context).forEach(mi -> this.removeModelItemFromView((ModelItem)mi, view));
        }
    }

    private void addModelItemToView(ModelItem modelItem, CustomView view, String identifier) {
        if (modelItem instanceof Element) {
            this.addElementToView((Element)modelItem, view, identifier);
        } else {
            this.addRelationshipToView((Relationship)modelItem, view);
        }
    }

    private void addElementToView(Element element, CustomView view, String identifier) {
        try {
            if (element instanceof CustomElement) {
                view.add((CustomElement)element);
            } else if (!StringUtils.isNullOrEmpty((String)identifier)) {
                throw new RuntimeException("The element \"" + identifier + "\" can not be added to this type of view");
            }
        }
        catch (ElementNotPermittedInViewException elementNotPermittedInViewException) {
            // empty catch block
        }
    }

    private void removeModelItemFromView(ModelItem modelItem, CustomView view) {
        if (modelItem instanceof Element) {
            this.removeElementFromView((Element)modelItem, view);
        } else {
            this.removeRelationshipFromView((Relationship)modelItem, (View)view);
        }
    }

    private void removeElementFromView(Element element, CustomView view) {
        if (element instanceof CustomElement) {
            view.remove((CustomElement)element);
        }
    }

    private void addRelationshipToView(Relationship relationship, CustomView view) {
        if (view.isElementInView(relationship.getSource()) && view.isElementInView(relationship.getDestination())) {
            view.add(relationship);
        }
    }
}

