/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DeploymentEnvironmentDslContext;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.DeploymentNode;

final class DeploymentNodeParser
extends AbstractParser {
    private static final String GRAMMAR = "deploymentNode <name> [description] [technology] [tags] [instances] {";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TECHNOLOGY_INDEX = 3;
    private static final int TAGS_INDEX = 4;
    private static final int INSTANCES_INDEX = 5;

    DeploymentNodeParser() {
    }

    DeploymentNode parse(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(5)) {
            throw new RuntimeException("Too many tokens, expected: deploymentNode <name> [description] [technology] [tags] [instances] {");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: deploymentNode <name> [description] [technology] [tags] [instances] {");
        }
        DeploymentNode deploymentNode = null;
        String name = tokens.get(1);
        String description = "";
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        String technology = "";
        if (tokens.includes(3)) {
            technology = tokens.get(3);
        }
        if (context instanceof DeploymentEnvironmentDslContext) {
            deploymentNode = context.getWorkspace().getModel().addDeploymentNode(((DeploymentEnvironmentDslContext)context).getEnvironment(), name, description, technology);
        } else if (context instanceof DeploymentNodeDslContext) {
            DeploymentNode parent = ((DeploymentNodeDslContext)context).getDeploymentNode();
            deploymentNode = parent.addDeploymentNode(name, description, technology);
        } else {
            throw new RuntimeException("Unexpected deployment node");
        }
        String tags = "";
        if (tokens.includes(4)) {
            tags = tokens.get(4);
            deploymentNode.addTags(tags.split(","));
        }
        int instances = 1;
        if (tokens.includes(5)) {
            String instancesAsString = tokens.get(5);
            try {
                instances = Integer.parseInt(instancesAsString);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("\"" + instancesAsString + "\" is not a valid number of instances");
            }
            deploymentNode.setInstances(instances);
        }
        return deploymentNode;
    }

    void parseTechnology(DeploymentNodeDslContext context, Tokens tokens) {
        int index = 1;
        if (tokens.hasMoreThan(index)) {
            throw new RuntimeException("Too many tokens, expected: technology <technology>");
        }
        if (!tokens.includes(index)) {
            throw new RuntimeException("Expected: technology <technology>");
        }
        String technology = tokens.get(index);
        context.getDeploymentNode().setTechnology(technology);
    }
}

