/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.DeploymentEnvironment;
import com.structurizr.dsl.DeploymentEnvironmentDslContext;
import com.structurizr.dsl.IdentifierScope;
import com.structurizr.dsl.IdentifiersRegister;
import com.structurizr.dsl.ModelItemDslContext;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;

abstract class DslContext {
    static final String CONTEXT_START_TOKEN = "{";
    static final String CONTEXT_END_TOKEN = "}";
    private Workspace workspace;
    private boolean extendingWorkspace;
    protected IdentifiersRegister identifersRegister = new IdentifiersRegister();

    DslContext() {
    }

    Workspace getWorkspace() {
        return this.workspace;
    }

    void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    boolean isExtendingWorkspace() {
        return this.extendingWorkspace;
    }

    void setExtendingWorkspace(boolean extendingWorkspace) {
        this.extendingWorkspace = extendingWorkspace;
    }

    void setIdentifierRegister(IdentifiersRegister identifersRegister) {
        this.identifersRegister = identifersRegister;
    }

    Element getElement(String identifier) {
        Element element = this.identifersRegister.getElement(identifier.toLowerCase());
        if (element == null && this.identifersRegister.getIdentifierScope() == IdentifierScope.Hierarchical) {
            if (this instanceof ModelItemDslContext) {
                ModelItemDslContext modelItemDslContext = (ModelItemDslContext)this;
                if (modelItemDslContext.getModelItem() instanceof Element) {
                    for (Element parent = (Element)modelItemDslContext.getModelItem(); parent != null && element == null; parent = parent.getParent()) {
                        String parentIdentifier = this.identifersRegister.findIdentifier(parent);
                        element = this.identifersRegister.getElement(parentIdentifier + "." + identifier);
                    }
                }
            } else if (this instanceof DeploymentEnvironmentDslContext) {
                DeploymentEnvironmentDslContext deploymentEnvironmentDslContext = (DeploymentEnvironmentDslContext)this;
                DeploymentEnvironment deploymentEnvironment = new DeploymentEnvironment(deploymentEnvironmentDslContext.getEnvironment());
                String parentIdentifier = this.identifersRegister.findIdentifier(deploymentEnvironment);
                element = this.identifersRegister.getElement(parentIdentifier + "." + identifier);
            }
        }
        return element;
    }

    Relationship getRelationship(String identifier) {
        return this.identifersRegister.getRelationship(identifier.toLowerCase());
    }

    void end() {
    }
}

