/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.DeploymentViewDslContext;
import com.structurizr.dsl.DeploymentViewExpressionParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.dsl.ViewContentParser;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.ElementNotPermittedInViewException;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

final class DeploymentViewContentParser
extends ViewContentParser {
    private static final int FIRST_IDENTIFIER_INDEX = 1;

    DeploymentViewContentParser() {
    }

    void parseInclude(DeploymentViewDslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: include <*|identifier> [*|identifier...]");
        }
        DeploymentView view = context.getView();
        for (int i = 1; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (token.equals("*") || token.equals("element==*")) {
                view.addDefaultElements();
                continue;
            }
            if (this.isExpression(token)) {
                new DeploymentViewExpressionParser().parseExpression(token, context).forEach(mi -> this.addModelItemToView((ModelItem)mi, view, null));
                continue;
            }
            new DeploymentViewExpressionParser().parseIdentifier(token, context).forEach(mi -> this.addModelItemToView((ModelItem)mi, view, token));
        }
    }

    void parseExclude(DeploymentViewDslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: exclude <identifier> [identifier...]");
        }
        DeploymentView view = context.getView();
        for (int i = 1; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (this.isExpression(token)) {
                new DeploymentViewExpressionParser().parseExpression(token, context).forEach(e -> this.removeModelItemFromView((ModelItem)e, view));
                continue;
            }
            new DeploymentViewExpressionParser().parseIdentifier(token, context).forEach(mi -> this.removeModelItemFromView((ModelItem)mi, view));
        }
    }

    private void addModelItemToView(ModelItem modelItem, DeploymentView view, String identifier) {
        if (modelItem instanceof Element) {
            this.addElementToView((Element)modelItem, view, identifier);
        } else {
            this.addRelationshipToView((Relationship)modelItem, view);
        }
    }

    private void addElementToView(Element element, DeploymentView view, String identifier) {
        try {
            if (element instanceof CustomElement) {
                view.add((CustomElement)element);
            } else if (element instanceof DeploymentNode) {
                view.add((DeploymentNode)element);
            } else if (element instanceof InfrastructureNode) {
                view.add((InfrastructureNode)element);
            } else if (element instanceof SoftwareSystem) {
                view.getModel().getElements().stream().filter(e -> e instanceof SoftwareSystemInstance).map(e -> (SoftwareSystemInstance)e).filter(ssi -> ssi.getSoftwareSystem().equals(element) && ssi.getEnvironment().equals(view.getEnvironment())).forEach(arg_0 -> ((DeploymentView)view).add(arg_0));
            } else if (element instanceof SoftwareSystemInstance) {
                view.add((SoftwareSystemInstance)element);
            } else if (element instanceof Container) {
                view.getModel().getElements().stream().filter(e -> e instanceof ContainerInstance).map(e -> (ContainerInstance)e).filter(ci -> ci.getContainer().equals(element) && ci.getEnvironment().equals(view.getEnvironment())).forEach(arg_0 -> ((DeploymentView)view).add(arg_0));
            } else if (element instanceof ContainerInstance) {
                view.add((ContainerInstance)element);
            } else if (!StringUtils.isNullOrEmpty((String)identifier)) {
                throw new RuntimeException("The element \"" + identifier + "\" can not be added to this type of view");
            }
        }
        catch (ElementNotPermittedInViewException elementNotPermittedInViewException) {
            // empty catch block
        }
    }

    private void removeModelItemFromView(ModelItem modelItem, DeploymentView view) {
        if (modelItem instanceof Element) {
            this.removeElementFromView((Element)modelItem, view);
        } else {
            this.removeRelationshipFromView((Relationship)modelItem, (View)view);
        }
    }

    private void removeElementFromView(Element element, DeploymentView view) {
        if (element instanceof CustomElement) {
            view.remove((CustomElement)element);
        } else if (element instanceof DeploymentNode) {
            view.remove((DeploymentNode)element);
        } else if (element instanceof InfrastructureNode) {
            view.remove((InfrastructureNode)element);
        } else if (element instanceof SoftwareSystem) {
            view.getModel().getElements().stream().filter(e -> e instanceof SoftwareSystemInstance).map(e -> (SoftwareSystemInstance)e).filter(ssi -> ssi.getSoftwareSystem().equals(element) && ssi.getEnvironment().equals(view.getEnvironment())).forEach(arg_0 -> ((DeploymentView)view).remove(arg_0));
        } else if (element instanceof SoftwareSystemInstance) {
            view.remove((SoftwareSystemInstance)element);
        } else if (element instanceof Container) {
            view.getModel().getElements().stream().filter(e -> e instanceof ContainerInstance).map(e -> (ContainerInstance)e).filter(ci -> ci.getContainer().equals(element) && ci.getEnvironment().equals(view.getEnvironment())).forEach(arg_0 -> ((DeploymentView)view).remove(arg_0));
        } else if (element instanceof ContainerInstance) {
            view.remove((ContainerInstance)element);
        }
    }

    private void addRelationshipToView(Relationship relationship, DeploymentView view) {
        if (view.isElementInView(relationship.getSource()) && view.isElementInView(relationship.getDestination())) {
            view.add(relationship);
        } else {
            Element sourceElement = relationship.getSource();
            Element destinationElement = relationship.getDestination();
            if ((sourceElement instanceof SoftwareSystem || sourceElement instanceof Container) && (destinationElement instanceof SoftwareSystem || destinationElement instanceof Container)) {
                String relationshipId = relationship.getId();
                Set replicatedRelationships = view.getModel().getRelationships().stream().filter(r -> relationshipId.equals(r.getLinkedRelationshipId())).collect(Collectors.toSet());
                for (Relationship replicatedRelationship : replicatedRelationships) {
                    if (!view.isElementInView(replicatedRelationship.getSource()) || !view.isElementInView(replicatedRelationship.getDestination())) continue;
                    view.add(replicatedRelationship);
                }
            }
        }
    }

    @Override
    protected void removeRelationshipFromView(Relationship relationship, View view) {
        view.remove(relationship);
        Collection replicatedRelationshipsInView = view.getRelationships().stream().map(RelationshipView::getRelationship).filter(r -> r.getLinkedRelationshipId() != null && r.getLinkedRelationshipId().equals(relationship.getId())).collect(Collectors.toSet());
        for (Relationship r2 : replicatedRelationshipsInView) {
            view.remove(r2);
        }
    }
}

