/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.DeploymentEnvironment;
import com.structurizr.dsl.DeploymentEnvironmentDslContext;
import com.structurizr.dsl.IdentifierScope;
import com.structurizr.dsl.IdentifiersRegister;
import com.structurizr.dsl.ModelItemDslContext;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

abstract class DslContext {
    private static final String PLUGINS_DIRECTORY_NAME = "plugins";
    static final String CONTEXT_START_TOKEN = "{";
    static final String CONTEXT_END_TOKEN = "}";
    private Workspace workspace;
    private boolean extendingWorkspace;
    protected IdentifiersRegister identifiersRegister = new IdentifiersRegister();

    DslContext() {
    }

    Workspace getWorkspace() {
        return this.workspace;
    }

    void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    boolean isExtendingWorkspace() {
        return this.extendingWorkspace;
    }

    void setExtendingWorkspace(boolean extendingWorkspace) {
        this.extendingWorkspace = extendingWorkspace;
    }

    void setIdentifierRegister(IdentifiersRegister identifersRegister) {
        this.identifiersRegister = identifersRegister;
    }

    Element getElement(String identifier) {
        Element element = this.identifiersRegister.getElement(identifier.toLowerCase());
        if (element == null && this.identifiersRegister.getIdentifierScope() == IdentifierScope.Hierarchical) {
            if (this instanceof ModelItemDslContext) {
                ModelItemDslContext modelItemDslContext = (ModelItemDslContext)this;
                if (modelItemDslContext.getModelItem() instanceof Element) {
                    for (Element parent = (Element)modelItemDslContext.getModelItem(); parent != null && element == null; parent = parent.getParent()) {
                        String parentIdentifier = this.identifiersRegister.findIdentifier(parent);
                        element = this.identifiersRegister.getElement(parentIdentifier + "." + identifier);
                    }
                }
            } else if (this instanceof DeploymentEnvironmentDslContext) {
                DeploymentEnvironmentDslContext deploymentEnvironmentDslContext = (DeploymentEnvironmentDslContext)this;
                DeploymentEnvironment deploymentEnvironment = new DeploymentEnvironment(deploymentEnvironmentDslContext.getEnvironment());
                String parentIdentifier = this.identifiersRegister.findIdentifier(deploymentEnvironment);
                element = this.identifiersRegister.getElement(parentIdentifier + "." + identifier);
            }
        }
        return element;
    }

    Relationship getRelationship(String identifier) {
        return this.identifiersRegister.getRelationship(identifier.toLowerCase());
    }

    protected Class loadClass(String fqn, File dslFile) throws Exception {
        File[] jarFiles;
        File pluginsDirectory = new File(dslFile.getParent(), PLUGINS_DIRECTORY_NAME);
        URL[] urls = new URL[]{};
        if (pluginsDirectory.exists() && (jarFiles = pluginsDirectory.listFiles((dir, name) -> name.endsWith(".jar"))) != null) {
            urls = new URL[jarFiles.length];
            for (int i = 0; i < jarFiles.length; ++i) {
                try {
                    urls[i] = jarFiles[i].toURI().toURL();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        URLClassLoader childClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        return childClassLoader.loadClass(fqn);
    }

    void end() {
    }
}

