/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.StructurizrDslPlugin;
import com.structurizr.dsl.StructurizrDslPluginContext;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

class PluginDslContext
extends DslContext {
    private final String fullyQualifiedClassName;
    private final File dslFile;
    private final Map<String, String> parameters = new HashMap<String, String>();

    PluginDslContext(String fullyQualifiedClassName, File dslFile) {
        this.fullyQualifiedClassName = fullyQualifiedClassName;
        this.dslFile = dslFile;
    }

    void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    void end() {
        try {
            Class pluginClass = this.loadClass(this.fullyQualifiedClassName, this.dslFile);
            StructurizrDslPlugin plugin = (StructurizrDslPlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            StructurizrDslPluginContext pluginContext = new StructurizrDslPluginContext(this.getWorkspace(), this.parameters);
            plugin.run(pluginContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error running plugin " + this.fullyQualifiedClassName + ", caused by " + e.getClass().getName() + ": " + e.getMessage());
        }
    }
}

