/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractExpressionParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.CustomElement;
import com.structurizr.model.Element;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import java.util.LinkedHashSet;
import java.util.Set;

final class StaticViewExpressionParser
extends AbstractExpressionParser {
    StaticViewExpressionParser() {
    }

    @Override
    protected Set<Element> evaluateElementTypeExpression(String expr, DslContext context) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        String type = expr.substring("element.type==".length());
        switch (type.toLowerCase()) {
            case "custom": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof CustomElement).forEach(elements::add);
                break;
            }
            case "person": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof Person).forEach(elements::add);
                break;
            }
            case "softwaresystem": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof SoftwareSystem).forEach(elements::add);
                break;
            }
            case "container": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof Container).forEach(elements::add);
                break;
            }
            case "component": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof Component).forEach(elements::add);
                break;
            }
            default: {
                throw new RuntimeException("The element type of \"" + type + "\" is not valid for this view");
            }
        }
        return elements;
    }

    @Override
    protected Set<Element> findAfferentCouplings(Element element) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        elements.addAll(this.findAfferentCouplings(element, CustomElement.class));
        elements.addAll(this.findAfferentCouplings(element, Person.class));
        elements.addAll(this.findAfferentCouplings(element, SoftwareSystem.class));
        elements.addAll(this.findAfferentCouplings(element, Container.class));
        elements.addAll(this.findAfferentCouplings(element, Component.class));
        return elements;
    }

    @Override
    protected Set<Element> findEfferentCouplings(Element element) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        elements.addAll(this.findEfferentCouplings(element, CustomElement.class));
        elements.addAll(this.findEfferentCouplings(element, Person.class));
        elements.addAll(this.findEfferentCouplings(element, SoftwareSystem.class));
        elements.addAll(this.findEfferentCouplings(element, Container.class));
        elements.addAll(this.findEfferentCouplings(element, Component.class));
        return elements;
    }
}

