/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.ElementStyleDslContext;
import com.structurizr.dsl.IconUtils;
import com.structurizr.dsl.Tokens;
import com.structurizr.util.ImageUtils;
import com.structurizr.util.StringUtils;
import com.structurizr.view.Border;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.Shape;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

final class ElementStyleParser
extends AbstractParser {
    private static final int FIRST_PROPERTY_INDEX = 1;

    ElementStyleParser() {
    }

    ElementStyle parseElementStyle(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: element <tag> {");
        }
        if (tokens.includes(1)) {
            String tag = tokens.get(1);
            if (StringUtils.isNullOrEmpty((String)tag)) {
                throw new RuntimeException("A tag must be specified");
            }
            Workspace workspace = context.getWorkspace();
            return workspace.getViews().getConfiguration().getStyles().addElementStyle(tag);
        }
        throw new RuntimeException("Expected: element <tag> {");
    }

    void parseShape(ElementStyleDslContext context, Tokens tokens) {
        String shape;
        HashMap<String, Shape> shapes = new HashMap<String, Shape>();
        String shapesAsString = "";
        for (Shape shape2 : Shape.values()) {
            shapes.put(shape2.toString().toLowerCase(), shape2);
            shapesAsString = shapesAsString + shape2;
            shapesAsString = shapesAsString + "|";
        }
        shapesAsString = shapesAsString.substring(0, shapesAsString.length() - 1);
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: shape <" + shapesAsString + ">");
        }
        if (tokens.includes(1)) {
            shape = tokens.get(1).toLowerCase();
            if (!shapes.containsKey(shape)) {
                throw new RuntimeException("The shape \"" + shape + "\" is not valid");
            }
        } else {
            throw new RuntimeException("Expected: shape <" + shapesAsString + ">");
        }
        style.setShape((Shape)shapes.get(shape));
    }

    void parseBackground(ElementStyleDslContext context, Tokens tokens) {
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: background <#rrggbb>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: background <#rrggbb>");
        }
        String colour = tokens.get(1);
        style.setBackground(colour);
    }

    void parseStroke(ElementStyleDslContext context, Tokens tokens) {
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: stroke <#rrggbb>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: stroke <#rrggbb>");
        }
        String colour = tokens.get(1);
        style.setStroke(colour);
    }

    void parseColour(ElementStyleDslContext context, Tokens tokens) {
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: colour <#rrggbb>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: colour <#rrggbb>");
        }
        String colour = tokens.get(1);
        style.setColor(colour);
    }

    void parseBorder(ElementStyleDslContext context, Tokens tokens) {
        String border;
        HashMap<String, Border> borders = new HashMap<String, Border>();
        for (Border border2 : Border.values()) {
            borders.put(border2.toString().toLowerCase(), border2);
        }
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: border <solid|dashed|dotted>");
        }
        if (tokens.includes(1)) {
            border = tokens.get(1).toLowerCase();
            if (!borders.containsKey(border)) {
                throw new RuntimeException("The border \"" + border + "\" is not valid");
            }
        } else {
            throw new RuntimeException("Expected: border <solid|dashed|dotted>");
        }
        style.setBorder((Border)borders.get(border));
    }

    void parseOpacity(ElementStyleDslContext context, Tokens tokens) {
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: opacity <0-100>");
        }
        if (tokens.includes(1)) {
            String opacityAsString = tokens.get(1);
            try {
                int opacity = Integer.parseInt(opacityAsString);
                style.setOpacity(Integer.valueOf(opacity));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Opacity must be an integer between 0 and 100");
            }
        } else {
            throw new RuntimeException("Expected: opacity <0-100>");
        }
    }

    void parseWidth(ElementStyleDslContext context, Tokens tokens) {
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: width <number>");
        }
        if (tokens.includes(1)) {
            String widthAsString = tokens.get(1);
            try {
                int width = Integer.parseInt(widthAsString);
                style.setWidth(Integer.valueOf(width));
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Width must be a positive integer");
            }
        } else {
            throw new RuntimeException("Expected: width <number>");
        }
    }

    void parseHeight(ElementStyleDslContext context, Tokens tokens) {
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: height <number>");
        }
        if (tokens.includes(1)) {
            String heightAsString = tokens.get(1);
            try {
                int height = Integer.parseInt(heightAsString);
                style.setHeight(Integer.valueOf(height));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Height must be a positive integer");
            }
        } else {
            throw new RuntimeException("Expected: height <number>");
        }
    }

    void parseFontSize(ElementStyleDslContext context, Tokens tokens) {
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: fontSize <number>");
        }
        if (tokens.includes(1)) {
            String fontSizeAsString = tokens.get(1);
            try {
                int fontSize = Integer.parseInt(fontSizeAsString);
                style.setFontSize(Integer.valueOf(fontSize));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Font size must be a positive integer");
            }
        } else {
            throw new RuntimeException("Expected: fontSize <number>");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseMetadata(ElementStyleDslContext context, Tokens tokens) {
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: metadata <true|false>");
        }
        if (!tokens.includes(1)) throw new RuntimeException("Expected: metadata <true|false>");
        String metadata = tokens.get(1);
        if ("true".equalsIgnoreCase(metadata)) {
            style.setMetadata(Boolean.valueOf(true));
            return;
        } else {
            if (!"false".equalsIgnoreCase(metadata)) throw new RuntimeException("Metadata must be true or false");
            style.setMetadata(Boolean.valueOf(false));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseDescription(ElementStyleDslContext context, Tokens tokens) {
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: description <true|false>");
        }
        if (!tokens.includes(1)) throw new RuntimeException("Expected: description <true|false>");
        String description = tokens.get(1);
        if ("true".equalsIgnoreCase(description)) {
            style.setDescription(Boolean.valueOf(true));
            return;
        } else {
            if (!"false".equalsIgnoreCase(description)) throw new RuntimeException("Description must be true or false");
            style.setDescription(Boolean.valueOf(false));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseIcon(ElementStyleDslContext context, Tokens tokens, boolean restricted) {
        ElementStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: icon <file|url>");
        }
        if (!tokens.includes(1)) throw new RuntimeException("Expected: icon <file|url>");
        String path = tokens.get(1);
        if (path.startsWith("data:image/") || path.startsWith("https://") || path.startsWith("http://")) {
            if (!IconUtils.isSupported(path)) throw new IllegalArgumentException("Only PNG and JPG URLs/data URIs are supported: " + path);
            style.setIcon(path);
            return;
        }
        if (restricted) return;
        File file = new File(context.getFile().getParent(), path);
        if (!file.exists() || file.isDirectory()) throw new RuntimeException(path + " does not exist");
        try {
            style.setIcon(ImageUtils.getImageAsDataUri((File)file));
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

