/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.RelationshipStyleDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.util.StringUtils;
import com.structurizr.view.LineStyle;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.Routing;
import java.util.HashMap;

final class RelationshipStyleParser
extends AbstractParser {
    private static final int FIRST_PROPERTY_INDEX = 1;

    RelationshipStyleParser() {
    }

    RelationshipStyle parseRelationshipStyle(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: relationship <tag> {");
        }
        if (tokens.includes(1)) {
            String tag = tokens.get(1);
            if (StringUtils.isNullOrEmpty((String)tag)) {
                throw new RuntimeException("A tag must be specified");
            }
            Workspace workspace = context.getWorkspace();
            return workspace.getViews().getConfiguration().getStyles().addRelationshipStyle(tag);
        }
        throw new RuntimeException("Expected: relationship <tag> {");
    }

    void parseThickness(RelationshipStyleDslContext context, Tokens tokens) {
        RelationshipStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: thickness <number>");
        }
        if (tokens.includes(1)) {
            String thicknessAsString = tokens.get(1);
            try {
                int thickness = Integer.parseInt(thicknessAsString);
                style.setThickness(Integer.valueOf(thickness));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Thickness must be a positive integer");
            }
        } else {
            throw new RuntimeException("Expected: thickness <number>");
        }
    }

    void parseColour(RelationshipStyleDslContext context, Tokens tokens) {
        RelationshipStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: colour <#rrggbb>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: colour <#rrggbb>");
        }
        String colour = tokens.get(1);
        style.setColor(colour);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseDashed(RelationshipStyleDslContext context, Tokens tokens) {
        RelationshipStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: dashed <true|false>");
        }
        if (!tokens.includes(1)) throw new RuntimeException("Expected: dashed <true|false>");
        String dashed = tokens.get(1);
        if ("true".equalsIgnoreCase(dashed)) {
            style.setDashed(Boolean.valueOf(true));
            return;
        } else {
            if (!"false".equalsIgnoreCase(dashed)) throw new RuntimeException("Dashed must be true or false");
            style.setDashed(Boolean.valueOf(false));
        }
    }

    void parseOpacity(RelationshipStyleDslContext context, Tokens tokens) {
        RelationshipStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: opacity <0-100>");
        }
        if (tokens.includes(1)) {
            String opacityAsString = tokens.get(1);
            try {
                int opacity = Integer.parseInt(opacityAsString);
                style.setOpacity(Integer.valueOf(opacity));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Opacity must be an integer between 0 and 100");
            }
        } else {
            throw new RuntimeException("Expected: opacity <0-100>");
        }
    }

    void parseWidth(RelationshipStyleDslContext context, Tokens tokens) {
        RelationshipStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: width <number>");
        }
        if (tokens.includes(1)) {
            String widthAsString = tokens.get(1);
            try {
                int width = Integer.parseInt(widthAsString);
                style.setWidth(Integer.valueOf(width));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Width must be a positive integer");
            }
        } else {
            throw new RuntimeException("Expected: width <number>");
        }
    }

    void parseFontSize(RelationshipStyleDslContext context, Tokens tokens) {
        RelationshipStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: fontSize <number>");
        }
        if (tokens.includes(1)) {
            String fontSizeAsString = tokens.get(1);
            try {
                int fontSize = Integer.parseInt(fontSizeAsString);
                style.setFontSize(Integer.valueOf(fontSize));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Font size must be a positive integer");
            }
        } else {
            throw new RuntimeException("Expected: fontSize <number>");
        }
    }

    void parsePosition(RelationshipStyleDslContext context, Tokens tokens) {
        RelationshipStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: position <0-100>");
        }
        if (tokens.includes(1)) {
            String positionAsString = tokens.get(1);
            try {
                int opacity = Integer.parseInt(positionAsString);
                style.setPosition(Integer.valueOf(opacity));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Position must be an integer between 0 and 100");
            }
        } else {
            throw new RuntimeException("Expected: position <0-100>");
        }
    }

    void parseLineStyle(RelationshipStyleDslContext context, Tokens tokens) {
        String lineStyle;
        HashMap<String, LineStyle> lineStyles = new HashMap<String, LineStyle>();
        for (LineStyle lineStyle2 : LineStyle.values()) {
            lineStyles.put(lineStyle2.toString().toLowerCase(), lineStyle2);
        }
        RelationshipStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: style <solid|dashed|dotted>");
        }
        if (tokens.includes(1)) {
            lineStyle = tokens.get(1).toLowerCase();
            if (!lineStyles.containsKey(lineStyle)) {
                throw new RuntimeException("The line style \"" + lineStyle + "\" is not valid");
            }
        } else {
            throw new RuntimeException("Expected: style <solid|dashed|dotted>");
        }
        style.setStyle((LineStyle)lineStyles.get(lineStyle));
    }

    void parseRouting(RelationshipStyleDslContext context, Tokens tokens) {
        String routing;
        HashMap<String, Routing> routings = new HashMap<String, Routing>();
        for (Routing routing2 : Routing.values()) {
            routings.put(routing2.toString().toLowerCase(), routing2);
        }
        RelationshipStyle style = context.getStyle();
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: routing <direct|orthogonal|curved>");
        }
        if (tokens.includes(1)) {
            routing = tokens.get(1).toLowerCase();
            if (!routings.containsKey(routing)) {
                throw new RuntimeException("The routing \"" + routing + "\" is not valid");
            }
        } else {
            throw new RuntimeException("Expected: routing <direct|orthogonal|curved>");
        }
        style.setRouting((Routing)routings.get(routing));
    }
}

