/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.view.ComponentView;

final class ComponentViewParser
extends AbstractParser {
    private static final String GRAMMAR = "component <container identifier> [key] [description] {";
    private static final String VIEW_TYPE = "Component";
    private static final int CONTAINER_IDENTIFIER_INDEX = 1;
    private static final int KEY_INDEX = 2;
    private static final int DESCRIPTION_INDEX = 3;

    ComponentViewParser() {
    }

    ComponentView parse(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: component <container identifier> [key] [description] {");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: component <container identifier> [key] [description] {");
        }
        Workspace workspace = context.getWorkspace();
        String key = "";
        String description = "";
        String containerIdentifier = tokens.get(1);
        Element element = context.getElement(containerIdentifier);
        if (element == null) {
            throw new RuntimeException("The container \"" + containerIdentifier + "\" does not exist");
        }
        if (!(element instanceof Container)) {
            throw new RuntimeException("The element \"" + containerIdentifier + "\" is not a container");
        }
        Container container = (Container)element;
        key = tokens.includes(2) ? tokens.get(2) : this.removeNonWordCharacters(container.getSoftwareSystem().getName()) + "-" + this.removeNonWordCharacters(container.getName()) + "-" + VIEW_TYPE;
        this.validateViewKey(key);
        if (tokens.includes(3)) {
            description = tokens.get(3);
        }
        ComponentView view = workspace.getViews().createComponentView(container, key, description);
        view.setExternalSoftwareSystemBoundariesVisible(true);
        return view;
    }
}

