/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DeploymentGroup;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import java.util.HashSet;

final class ContainerInstanceParser
extends AbstractParser {
    private static final String GRAMMAR = "containerInstance <identifier> [deploymentGroups] [tags]";
    private static final int IDENTIFIER_INDEX = 1;
    private static final int DEPLOYMENT_GROUPS_TOKEN = 2;
    private static final int TAGS_INDEX = 3;

    ContainerInstanceParser() {
    }

    ContainerInstance parse(DeploymentNodeDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: containerInstance <identifier> [deploymentGroups] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: containerInstance <identifier> [deploymentGroups] [tags]");
        }
        String containerIdentifier = tokens.get(1);
        Element element = context.getElement(containerIdentifier, Container.class);
        if (element == null) {
            throw new RuntimeException("The container \"" + containerIdentifier + "\" does not exist");
        }
        DeploymentNode deploymentNode = context.getDeploymentNode();
        HashSet<String> deploymentGroups = new HashSet<String>();
        if (tokens.includes(2)) {
            String[] deploymentGroupReferences;
            String token = tokens.get(2);
            for (String deploymentGroupReference : deploymentGroupReferences = token.split(",")) {
                Element e = context.getElement(deploymentGroupReference);
                if (!(e instanceof DeploymentGroup)) continue;
                deploymentGroups.add(e.getName());
            }
        }
        ContainerInstance containerInstance = deploymentNode.add((Container)element, deploymentGroups.toArray(new String[0]));
        if (tokens.includes(3)) {
            String tags = tokens.get(3);
            containerInstance.addTags(tags.split(","));
        }
        return containerInstance;
    }
}

