/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.importer.DefaultImageImporter;
import com.structurizr.documentation.importer.DocumentationImporter;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.ContainerDslContext;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.SoftwareSystemDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.dsl.WorkspaceDslContext;
import java.io.File;
import java.lang.reflect.Constructor;

final class DocsParser
extends AbstractParser {
    private static final String DEFAULT_DOCUMENT_IMPORTER = "com.structurizr.documentation.importer.DefaultDocumentationImporter";
    private static final String GRAMMAR = "!docs <path> <fqn>";
    private static final int PATH_INDEX = 1;
    private static final int FQN_INDEX = 2;

    DocsParser() {
    }

    void parse(WorkspaceDslContext context, File dslFile, Tokens tokens) {
        this.parse(context, (Documentable)context.getWorkspace(), dslFile, tokens);
    }

    void parse(SoftwareSystemDslContext context, File dslFile, Tokens tokens) {
        this.parse(context, (Documentable)context.getSoftwareSystem(), dslFile, tokens);
    }

    void parse(ContainerDslContext context, File dslFile, Tokens tokens) {
        this.parse(context, (Documentable)context.getContainer(), dslFile, tokens);
    }

    private void parse(DslContext context, Documentable documentable, File dslFile, Tokens tokens) {
        if (tokens.hasMoreThan(2)) {
            throw new RuntimeException("Too many tokens, expected: !docs <path> <fqn>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: !docs <path> <fqn>");
        }
        String fullyQualifiedClassName = DEFAULT_DOCUMENT_IMPORTER;
        if (tokens.includes(2)) {
            fullyQualifiedClassName = tokens.get(2);
        }
        if (dslFile != null) {
            File path = new File(dslFile.getParentFile(), tokens.get(1));
            if (!path.exists()) {
                throw new RuntimeException("Documentation path " + path + " does not exist");
            }
            if (!path.isDirectory()) {
                throw new RuntimeException("Documentation path " + path + " is not a directory");
            }
            try {
                Class documentationImporterClass = context.loadClass(fullyQualifiedClassName, dslFile);
                Constructor constructor = documentationImporterClass.getDeclaredConstructor(new Class[0]);
                DocumentationImporter documentationImporter = (DocumentationImporter)constructor.newInstance(new Object[0]);
                documentationImporter.importDocumentation(documentable, path);
                if (!tokens.includes(2)) {
                    DefaultImageImporter imageImporter = new DefaultImageImporter();
                    imageImporter.importDocumentation(documentable, path);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Error importing documentation from " + path.getAbsolutePath() + ": " + fullyQualifiedClassName + " was not found");
            }
            catch (Exception e) {
                throw new RuntimeException("Error importing documentation from " + path.getAbsolutePath() + ": " + e.getMessage());
            }
        }
    }
}

