/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractRelationshipParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.GroupableElementDslContext;
import com.structurizr.dsl.ModelItemDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;

final class ExplicitRelationshipParser
extends AbstractRelationshipParser {
    private static final String GRAMMAR = "<identifier> -> <identifier> [description] [technology] [tags]";
    private static final int SOURCE_IDENTIFIER_INDEX = 0;
    private static final int DESTINATION_IDENTIFIER_INDEX = 2;
    private static final int DESCRIPTION_INDEX = 3;
    private static final int TECHNOLOGY_INDEX = 4;
    private static final int TAGS_INDEX = 5;

    ExplicitRelationshipParser() {
    }

    Relationship parse(DslContext context, Tokens tokens) {
        ModelItemDslContext modelItemDslContext;
        if (tokens.hasMoreThan(5)) {
            throw new RuntimeException("Too many tokens, expected: <identifier> -> <identifier> [description] [technology] [tags]");
        }
        if (!tokens.includes(2)) {
            throw new RuntimeException("Expected: <identifier> -> <identifier> [description] [technology] [tags]");
        }
        String sourceId = tokens.get(0);
        String destinationId = tokens.get(2);
        Element sourceElement = context.getElement(sourceId);
        Element destinationElement = context.getElement(destinationId);
        if (sourceElement == null) {
            if ("this".equalsIgnoreCase(sourceId) && context instanceof GroupableElementDslContext) {
                GroupableElementDslContext groupableElementDslContext = (GroupableElementDslContext)context;
                sourceElement = groupableElementDslContext.getElement();
            } else {
                throw new RuntimeException("The source element \"" + sourceId + "\" does not exist");
            }
        }
        if (destinationElement == null && "this".equalsIgnoreCase(destinationId) && context instanceof ModelItemDslContext && (modelItemDslContext = (ModelItemDslContext)context).getModelItem() instanceof Element) {
            destinationElement = (Element)modelItemDslContext.getModelItem();
        }
        if (destinationElement == null) {
            throw new RuntimeException("The destination element \"" + destinationId + "\" does not exist");
        }
        String description = "";
        if (tokens.includes(3)) {
            description = tokens.get(3);
        }
        String technology = "";
        if (tokens.includes(4)) {
            technology = tokens.get(4);
        }
        String[] tags = new String[]{};
        if (tokens.includes(5)) {
            tags = tokens.get(5).split(",");
        }
        return this.createRelationship(sourceElement, description, technology, tags, destinationElement);
    }
}

