/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.StructurizrDslFormatterException;
import com.structurizr.dsl.StructurizrDslTokens;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Enterprise;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Location;
import com.structurizr.model.Model;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.Perspective;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.util.WorkspaceUtils;
import com.structurizr.view.AutomaticLayout;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.ElementView;
import com.structurizr.view.FilteredView;
import com.structurizr.view.Font;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import com.structurizr.view.ViewSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public final class StructurizrDslFormatter
extends StructurizrDslTokens {
    private static final String DEFAULT_FONT = "Open Sans";
    private StringBuilder buf = new StringBuilder();
    private int indent = 0;

    public String format(File file) throws StructurizrDslFormatterException {
        if (file == null) {
            throw new StructurizrDslFormatterException("A file must be specified");
        }
        if (!file.exists()) {
            throw new StructurizrDslFormatterException("The file at " + file.getAbsolutePath() + " does not exist");
        }
        if (file.isDirectory()) {
            throw new StructurizrDslFormatterException("The file at " + file.getAbsolutePath() + " must be a single file");
        }
        try {
            return this.format(new String(Files.readAllBytes(file.toPath())));
        }
        catch (IOException e) {
            throw new StructurizrDslFormatterException(e.getMessage());
        }
    }

    public String format(String json) throws StructurizrDslFormatterException {
        boolean hasBranding;
        Model model;
        Workspace workspace;
        if (StringUtils.isNullOrEmpty((String)json)) {
            throw new StructurizrDslFormatterException("A JSON document must be specified");
        }
        try {
            workspace = WorkspaceUtils.fromJson((String)json);
            model = workspace.getModel();
        }
        catch (Exception e) {
            throw new StructurizrDslFormatterException(e.getMessage());
        }
        this.start("workspace", this.quote(workspace.getName()), this.quote(workspace.getDescription()));
        this.newline();
        this.start("!impliedRelationships", this.quote("false"));
        this.end();
        this.start("!identifiers", this.quote("hierarchical"));
        this.end();
        this.newline();
        this.start("model");
        List<Person> internalPeople = model.getPeople().stream().filter((? super T p) -> p.getLocation() == Location.Internal).sorted(Comparator.comparing(ModelItem::getId)).collect(Collectors.toList());
        List<SoftwareSystem> internalSoftwareSystems = model.getSoftwareSystems().stream().filter((? super T p) -> p.getLocation() == Location.Internal).sorted(Comparator.comparing(ModelItem::getId)).collect(Collectors.toList());
        if (workspace.getModel().getEnterprise() == null) {
            workspace.getModel().setEnterprise(new Enterprise("Enterprise"));
        }
        if (!(workspace.getModel().getEnterprise() == null || internalPeople.isEmpty() && internalSoftwareSystems.isEmpty())) {
            this.start("enterprise", this.quote(workspace.getModel().getEnterprise().getName()));
            internalPeople.forEach(this::format);
            internalSoftwareSystems.forEach(this::format);
            this.end();
        }
        model.getPeople().stream().filter((? super T p) -> p.getLocation() != Location.Internal).sorted(Comparator.comparing(ModelItem::getId)).forEach(this::format);
        model.getSoftwareSystems().stream().filter((? super T p) -> p.getLocation() != Location.Internal).sorted(Comparator.comparing(ModelItem::getId)).forEach(this::format);
        model.getRelationships().stream().sorted(Comparator.comparing(ModelItem::getId)).forEach(r -> {
            if (!(r.getSource() instanceof DeploymentElement) && !(r.getDestination() instanceof DeploymentElement)) {
                this.start(this.id((ModelItem)r.getSource(), true), "->", this.id((ModelItem)r.getDestination(), true), this.quote(r.getDescription()), this.quote(r.getTechnology()), this.quote(this.tags((Relationship)r)));
                this.formatModelItem((ModelItem)r);
                this.end();
            }
        });
        if (!workspace.getModel().getDeploymentNodes().isEmpty()) {
            this.newline();
            model.getDeploymentNodes().stream().map(DeploymentElement::getEnvironment).collect(Collectors.toSet()).stream().sorted().forEach(deploymentEnvironment -> {
                this.start(this.filter((String)deploymentEnvironment), "=", "deploymentEnvironment", this.quote(deploymentEnvironment));
                model.getDeploymentNodes().stream().filter((? super T dn) -> dn.getParent() == null && dn.getEnvironment().equals(deploymentEnvironment)).sorted(Comparator.comparing(ModelItem::getId)).forEach(this::format);
                this.end();
            });
            this.newline();
            model.getRelationships().stream().sorted(Comparator.comparing(ModelItem::getId)).forEach(r -> {
                if (StringUtils.isNullOrEmpty((String)r.getLinkedRelationshipId()) && (r.getSource() instanceof DeploymentElement || r.getDestination() instanceof DeploymentElement)) {
                    this.start(this.id((ModelItem)r.getSource(), true), "->", this.id((ModelItem)r.getDestination(), true), this.quote(r.getDescription()), this.quote(r.getTechnology()), this.quote(this.tags((Relationship)r)));
                    this.formatModelItem((ModelItem)r);
                    this.end();
                }
            });
        }
        this.end();
        boolean hasViews = !workspace.getViews().isEmpty();
        boolean hasStyles = !workspace.getViews().getConfiguration().getStyles().getElements().isEmpty() || !workspace.getViews().getConfiguration().getStyles().getRelationships().isEmpty();
        boolean hasThemes = workspace.getViews().getConfiguration().getThemes() != null && workspace.getViews().getConfiguration().getThemes().length > 0;
        boolean bl = hasBranding = workspace.getViews().getConfiguration().getBranding() != null && (!StringUtils.isNullOrEmpty((String)workspace.getViews().getConfiguration().getBranding().getLogo()) || workspace.getViews().getConfiguration().getBranding().getFont() != null);
        if (hasViews || hasStyles || hasThemes || hasBranding) {
            this.newline();
            this.start("views");
            ViewSet views = workspace.getViews();
            views.getSystemLandscapeViews().stream().sorted(Comparator.comparing(View::getKey)).forEach(view -> {
                if (view.getElements().size() > 0 || view.getRelationships().size() > 0) {
                    this.start("systemLandscape", this.quote(view.getKey().replaceAll(" ", "")), this.quote(view.getDescription()));
                    view.getElements().stream().map(ElementView::getElement).sorted(Comparator.comparing(ModelItem::getId)).forEach(e -> {
                        this.start("include", this.id((ModelItem)e, true));
                        this.end();
                    });
                    this.format(view.getAutomaticLayout());
                    this.end();
                    this.newline();
                }
            });
            views.getSystemContextViews().stream().sorted(Comparator.comparing(View::getKey)).forEach(view -> {
                if (view.getElements().size() > 0 || view.getRelationships().size() > 0) {
                    this.start("systemContext", this.id(view.getSoftwareSystem()), this.quote(view.getKey().replaceAll(" ", "")), this.quote(view.getDescription()));
                    view.getElements().stream().map(ElementView::getElement).sorted(Comparator.comparing(ModelItem::getId)).forEach(e -> {
                        this.start("include", this.id((ModelItem)e, true));
                        this.end();
                    });
                    this.format(view.getAutomaticLayout());
                    this.end();
                    this.newline();
                }
            });
            views.getContainerViews().stream().sorted(Comparator.comparing(View::getKey)).forEach(view -> {
                if (view.getElements().size() > 0 || view.getRelationships().size() > 0) {
                    this.start("container", this.id(view.getSoftwareSystem()), this.quote(view.getKey().replaceAll(" ", "")), this.quote(view.getDescription()));
                    view.getElements().stream().map(ElementView::getElement).sorted(Comparator.comparing(ModelItem::getId)).forEach(e -> {
                        this.start("include", this.id((ModelItem)e, true));
                        this.end();
                    });
                    this.format(view.getAutomaticLayout());
                    this.end();
                    this.newline();
                }
            });
            views.getComponentViews().stream().sorted(Comparator.comparing(View::getKey)).forEach(view -> {
                if (view.getElements().size() > 0 || view.getRelationships().size() > 0) {
                    this.start("component", this.id((ModelItem)view.getContainer(), true), this.quote(view.getKey().replaceAll(" ", "")), this.quote(view.getDescription()));
                    view.getElements().stream().map(ElementView::getElement).sorted(Comparator.comparing(ModelItem::getId)).forEach(e -> {
                        this.start("include", this.id((ModelItem)e, true));
                        this.end();
                    });
                    this.format(view.getAutomaticLayout());
                    this.end();
                    this.newline();
                }
            });
            views.getFilteredViews().stream().sorted(Comparator.comparing(FilteredView::getKey)).forEach(view -> {
                StringBuilder tags = new StringBuilder();
                for (String tag : view.getTags()) {
                    tags.append(tag);
                    tags.append(" ");
                }
                this.start("filtered", this.quote(view.getBaseViewKey().replaceAll(" ", "")), view.getMode().toString(), this.quote(tags.toString().trim()), this.quote(view.getKey().replaceAll(" ", "")), this.quote(view.getDescription()));
                this.end();
                this.newline();
            });
            views.getDynamicViews().stream().sorted(Comparator.comparing(View::getKey)).forEach(view -> {
                if (view.getElements().size() > 0 || view.getRelationships().size() > 0) {
                    if (StringUtils.isNullOrEmpty((String)view.getElementId())) {
                        this.start("dynamic", this.quote("*"), this.quote(view.getKey()), this.quote(view.getDescription()));
                    } else {
                        this.start("dynamic", this.id((ModelItem)view.getElement(), true), this.quote(view.getKey()), this.quote(view.getDescription()));
                    }
                    for (RelationshipView relationshipView : view.getRelationships()) {
                        Element destination;
                        Element source;
                        this.start("# " + relationshipView.getOrder());
                        this.end();
                        if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                            source = relationshipView.getRelationship().getDestination();
                            destination = relationshipView.getRelationship().getSource();
                        } else {
                            source = relationshipView.getRelationship().getSource();
                            destination = relationshipView.getRelationship().getDestination();
                        }
                        if (StringUtils.isNullOrEmpty((String)relationshipView.getDescription())) {
                            this.start(this.id((ModelItem)source, true), "->", this.id((ModelItem)destination, true));
                        } else {
                            this.start(this.id((ModelItem)source, true), "->", this.id((ModelItem)destination, true), this.quote(relationshipView.getDescription()));
                        }
                        this.end();
                    }
                    this.format(view.getAutomaticLayout());
                    this.end();
                    this.newline();
                }
            });
            views.getDeploymentViews().stream().sorted(Comparator.comparing(View::getKey)).forEach(view -> {
                if (view.getElements().size() > 0 || view.getRelationships().size() > 0) {
                    String scope = StringUtils.isNullOrEmpty((String)view.getSoftwareSystemId()) ? "*" : this.id(view.getSoftwareSystem());
                    this.start("deployment", scope, this.quote(view.getEnvironment()), this.quote(view.getKey()), this.quote(view.getDescription()));
                    LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
                    for (ElementView elementView : view.getElements()) {
                        DeploymentElement deploymentElement = (DeploymentElement)elementView.getElement();
                        if (deploymentElement instanceof DeploymentNode) continue;
                        elements.add(deploymentElement.getParent());
                    }
                    for (Element element : elements) {
                        this.start("include", this.id((ModelItem)element, true));
                        this.end();
                    }
                    this.format(view.getAutomaticLayout());
                    this.end();
                    this.newline();
                }
            });
            if (hasStyles) {
                this.start("styles");
                workspace.getViews().getConfiguration().getStyles().getElements().stream().sorted(Comparator.comparing(ElementStyle::getTag)).forEach(style -> {
                    boolean hasProperties = false;
                    this.start("element", this.quote(style.getTag()));
                    if (style.getShape() != null) {
                        hasProperties = true;
                        this.start("shape", this.quote(style.getShape()));
                        this.end();
                    }
                    if (!StringUtils.isNullOrEmpty((String)style.getIcon())) {
                        hasProperties = true;
                        this.start("icon", this.quote(style.getIcon()));
                        this.end();
                    }
                    if (style.getWidth() != null) {
                        hasProperties = true;
                        this.start("width", this.quote(style.getWidth()));
                        this.end();
                    }
                    if (style.getHeight() != null) {
                        hasProperties = true;
                        this.start("height", this.quote(style.getHeight()));
                        this.end();
                    }
                    if (!StringUtils.isNullOrEmpty((String)style.getBackground())) {
                        hasProperties = true;
                        this.start("background", this.quote(style.getBackground()));
                        this.end();
                    }
                    if (!StringUtils.isNullOrEmpty((String)style.getColor())) {
                        hasProperties = true;
                        this.start("color", this.quote(style.getColor()));
                        this.end();
                    }
                    if (!StringUtils.isNullOrEmpty((String)style.getStroke())) {
                        hasProperties = true;
                        this.start("stroke", this.quote(style.getStroke()));
                        this.end();
                    }
                    if (style.getFontSize() != null) {
                        hasProperties = true;
                        this.start("fontSize", this.quote(style.getFontSize()));
                        this.end();
                    }
                    if (style.getBorder() != null) {
                        hasProperties = true;
                        this.start("border", this.quote(style.getBorder()));
                        this.end();
                    }
                    if (style.getOpacity() != null) {
                        hasProperties = true;
                        this.start("opacity", this.quote(style.getOpacity()));
                        this.end();
                    }
                    if (style.getMetadata() != null) {
                        hasProperties = true;
                        this.start("metadata", this.quote(style.getMetadata()));
                        this.end();
                    }
                    if (style.getDescription() != null) {
                        hasProperties = true;
                        this.start("description", this.quote(style.getDescription()));
                        this.end();
                    }
                    if (!hasProperties) {
                        this.start("# empty style");
                        this.end();
                    }
                    this.end();
                });
                workspace.getViews().getConfiguration().getStyles().getRelationships().stream().sorted(Comparator.comparing(RelationshipStyle::getTag)).forEach(style -> {
                    boolean hasProperties = false;
                    this.start("relationship", this.quote(style.getTag()));
                    if (style.getThickness() != null) {
                        hasProperties = true;
                        this.start("thickness", this.quote(style.getThickness()));
                        this.end();
                    }
                    if (!StringUtils.isNullOrEmpty((String)style.getColor())) {
                        hasProperties = true;
                        this.start("color", this.quote(style.getColor()));
                        this.end();
                    }
                    if (style.getDashed() != null) {
                        hasProperties = true;
                        this.start("dashed", this.quote(style.getDashed()));
                        this.end();
                    }
                    if (style.getRouting() != null) {
                        hasProperties = true;
                        this.start("routing", this.quote(style.getRouting()));
                        this.end();
                    }
                    if (style.getFontSize() != null) {
                        hasProperties = true;
                        this.start("fontSize", this.quote(style.getFontSize()));
                        this.end();
                    }
                    if (style.getWidth() != null) {
                        hasProperties = true;
                        this.start("width", this.quote(style.getWidth()));
                        this.end();
                    }
                    if (style.getPosition() != null) {
                        hasProperties = true;
                        this.start("position", this.quote(style.getPosition()));
                        this.end();
                    }
                    if (style.getOpacity() != null) {
                        hasProperties = true;
                        this.start("opacity", this.quote(style.getOpacity()));
                        this.end();
                    }
                    if (!hasProperties) {
                        this.start("# empty style");
                        this.end();
                    }
                    this.end();
                });
                this.end();
            }
            if (hasThemes) {
                String[] themes;
                for (String theme : themes = views.getConfiguration().getThemes()) {
                    this.start("themes", this.quote(theme));
                    this.end();
                }
            }
            if (hasBranding) {
                this.newline();
                this.start("branding");
                String brandingLogo = workspace.getViews().getConfiguration().getBranding().getLogo();
                Font brandingFont = workspace.getViews().getConfiguration().getBranding().getFont();
                if (!StringUtils.isNullOrEmpty((String)brandingLogo)) {
                    this.start("logo", this.quote(brandingLogo));
                    this.end();
                }
                if (brandingFont != null) {
                    if (!StringUtils.isNullOrEmpty((String)brandingFont.getUrl())) {
                        this.start("font", this.quote(brandingFont.getName()), this.quote(brandingFont.getUrl()));
                        this.end();
                    } else if (!DEFAULT_FONT.equals(brandingFont.getName())) {
                        this.start("font", this.quote(brandingFont.getName()));
                        this.end();
                    }
                }
                this.end();
            }
            this.newline();
            this.end();
        }
        this.newline();
        this.end();
        return this.buf.toString().replaceAll("\\{\\s*}", "");
    }

    private void format(AutomaticLayout automaticLayout) {
        if (automaticLayout == null) {
            return;
        }
        String direction = "tb";
        switch (automaticLayout.getRankDirection()) {
            case TopBottom: {
                direction = "tb";
                break;
            }
            case BottomTop: {
                direction = "bt";
                break;
            }
            case LeftRight: {
                direction = "lr";
                break;
            }
            case RightLeft: {
                direction = "rl";
            }
        }
        this.start("autolayout", direction, "" + automaticLayout.getRankSeparation(), "" + automaticLayout.getNodeSeparation());
        this.end();
    }

    private void start(String ... tokens) {
        List<String> list = Arrays.asList(tokens);
        boolean repeat = true;
        while (repeat) {
            if (list.get(list.size() - 1).equals("\"\"")) {
                list = list.subList(0, list.size() - 1);
                repeat = true;
                continue;
            }
            repeat = false;
        }
        this.format(true, list.toArray(new String[0]));
        ++this.indent;
    }

    private void end() {
        --this.indent;
        this.format(false, "}");
    }

    private void newline() {
        this.buf.append(System.lineSeparator());
    }

    private String quote(Object content) {
        String s = "";
        if (content != null) {
            s = content.toString();
        }
        s = s.replaceAll("\\n", " ");
        s = s.replaceAll("\\\"", "\\\\\"");
        return String.format("\"%s\"", s);
    }

    private void format(boolean startContext, String ... tokens) {
        this.indent();
        for (int i = 0; i < tokens.length; ++i) {
            this.buf.append(tokens[i]);
            if (i >= tokens.length - 1) continue;
            this.buf.append(" ");
        }
        if (startContext) {
            this.buf.append(" ");
            this.buf.append("{");
        }
        this.newline();
    }

    private void indent() {
        for (int i = 0; i < this.indent * 4; ++i) {
            this.buf.append(" ");
        }
    }

    private String tags(Element element) {
        String tags = element.getTags();
        String defaultTags = "";
        if (element instanceof Person) {
            defaultTags = "Element,Person";
        } else if (element instanceof SoftwareSystem) {
            defaultTags = "Element,Software System";
        } else if (element instanceof Container) {
            defaultTags = "Element,Container";
        } else if (element instanceof Component) {
            defaultTags = "Element,Component";
        } else if (element instanceof DeploymentNode) {
            defaultTags = "Element,Deployment Node";
        } else if (element instanceof InfrastructureNode) {
            defaultTags = "Element,Infrastructure Node";
        } else if (element instanceof ContainerInstance) {
            defaultTags = "Container Instance";
        } else if (element instanceof SoftwareSystemInstance) {
            defaultTags = "Software System Instance";
        }
        tags = tags.substring(defaultTags.length());
        if (tags.startsWith(",")) {
            tags = tags.substring(1);
        }
        return tags;
    }

    private String tags(Relationship relationship) {
        String defaultTags;
        String tags = relationship.getTags();
        if (tags.startsWith(defaultTags = "Relationship") && (tags = tags.substring(defaultTags.length())).startsWith(",")) {
            tags = tags.substring(1);
        }
        return tags;
    }

    private void format(Person person) {
        this.start(this.id(person), "=", "person", this.quote(person.getName()), this.quote(person.getDescription()), this.quote(this.tags((Element)person)));
        this.formatModelItem((ModelItem)person);
        this.end();
    }

    private void formatModelItem(ModelItem modelItem) {
        if (!StringUtils.isNullOrEmpty((String)modelItem.getUrl())) {
            this.start("url", this.quote(modelItem.getUrl()));
            this.end();
        }
        if (!modelItem.getProperties().isEmpty()) {
            this.start("properties");
            for (String name : modelItem.getProperties().keySet()) {
                this.start(this.quote(name), this.quote(modelItem.getProperties().get(name)));
                this.end();
            }
            this.end();
        }
        if (!modelItem.getPerspectives().isEmpty()) {
            this.start("perspectives");
            for (Perspective perspective : modelItem.getPerspectives()) {
                this.start(this.quote(perspective.getName()), this.quote(perspective.getDescription()));
                this.end();
            }
            this.end();
        }
    }

    private String id(ModelItem modelItem) {
        if (modelItem instanceof Person) {
            return this.id((Person)modelItem);
        }
        if (modelItem instanceof SoftwareSystem) {
            return this.id((SoftwareSystem)modelItem);
        }
        if (modelItem instanceof Container) {
            return this.id((Container)modelItem);
        }
        if (modelItem instanceof Component) {
            return this.id((Component)modelItem);
        }
        if (modelItem instanceof DeploymentNode) {
            return this.id((DeploymentNode)modelItem);
        }
        if (modelItem instanceof InfrastructureNode) {
            return this.id((InfrastructureNode)modelItem);
        }
        if (modelItem instanceof SoftwareSystemInstance) {
            return this.id((SoftwareSystemInstance)modelItem);
        }
        if (modelItem instanceof ContainerInstance) {
            return this.id((ContainerInstance)modelItem);
        }
        return modelItem.getId();
    }

    private String id(ModelItem modelItem, boolean hierarchical) {
        if (hierarchical && modelItem instanceof Element) {
            Element element = (Element)modelItem;
            if (element.getParent() == null) {
                if (element instanceof DeploymentNode) {
                    DeploymentNode dn = (DeploymentNode)element;
                    return this.filter(dn.getEnvironment()) + "." + this.id(dn);
                }
                return this.id((ModelItem)element);
            }
            return this.id((ModelItem)element.getParent(), true) + "." + this.id(modelItem);
        }
        return this.id(modelItem);
    }

    private String id(Person person) {
        return this.filter(person.getName());
    }

    private String id(SoftwareSystem softwareSystem) {
        return this.filter(softwareSystem.getName());
    }

    private String id(Container container) {
        return this.filter(container.getName());
    }

    private String id(Component component) {
        return this.filter(component.getName());
    }

    private String id(DeploymentNode deploymentNode) {
        return this.filter(deploymentNode.getName());
    }

    private String id(InfrastructureNode infrastructureNode) {
        return this.filter(infrastructureNode.getName());
    }

    private String id(SoftwareSystemInstance softwareSystemInstance) {
        return this.filter(softwareSystemInstance.getName()) + "_" + softwareSystemInstance.getInstanceId();
    }

    private String id(ContainerInstance containerInstance) {
        return this.filter(containerInstance.getName()) + "_" + containerInstance.getInstanceId();
    }

    private String filter(String s) {
        return s.replaceAll("\\W", "");
    }

    private void format(SoftwareSystem softwareSystem) {
        this.start(this.id(softwareSystem), "=", "softwareSystem", this.quote(softwareSystem.getName()), this.quote(softwareSystem.getDescription()), this.quote(this.tags((Element)softwareSystem)));
        this.formatModelItem((ModelItem)softwareSystem);
        softwareSystem.getContainers().stream().sorted(Comparator.comparing(ModelItem::getId)).forEach(this::format);
        this.end();
    }

    private void format(Container container) {
        this.start(this.id(container), "=", "container", this.quote(container.getName()), this.quote(container.getDescription()), this.quote(container.getTechnology()), this.quote(this.tags((Element)container)));
        this.formatModelItem((ModelItem)container);
        container.getComponents().stream().sorted(Comparator.comparing(ModelItem::getId)).forEach(this::format);
        this.end();
    }

    private void format(Component component) {
        this.start(this.id(component), "=", "component", this.quote(component.getName()), this.quote(component.getDescription()), this.quote(component.getTechnology()), this.quote(this.tags((Element)component)));
        this.formatModelItem((ModelItem)component);
        this.end();
    }

    private void format(DeploymentNode deploymentNode) {
        this.start(this.id(deploymentNode), "=", "deploymentNode", this.quote(deploymentNode.getName()), this.quote(deploymentNode.getDescription()), this.quote(deploymentNode.getTechnology()), this.quote(this.tags((Element)deploymentNode)));
        this.formatModelItem((ModelItem)deploymentNode);
        deploymentNode.getInfrastructureNodes().stream().sorted(Comparator.comparing(ModelItem::getId)).forEach(this::format);
        deploymentNode.getSoftwareSystemInstances().stream().sorted(Comparator.comparing(ModelItem::getId)).forEach(this::format);
        deploymentNode.getContainerInstances().stream().sorted(Comparator.comparing(ModelItem::getId)).forEach(this::format);
        deploymentNode.getChildren().stream().sorted(Comparator.comparing(ModelItem::getId)).forEach(this::format);
        this.end();
    }

    private void format(InfrastructureNode infrastructureNode) {
        this.start(this.id(infrastructureNode), "=", "infrastructureNode", this.quote(infrastructureNode.getName()), this.quote(infrastructureNode.getDescription()), this.quote(infrastructureNode.getTechnology()), this.quote(this.tags((Element)infrastructureNode)));
        this.formatModelItem((ModelItem)infrastructureNode);
        this.end();
    }

    private void format(SoftwareSystemInstance softwareSystemInstance) {
        this.start(this.id(softwareSystemInstance), "=", "softwareSystemInstance", this.id((ModelItem)softwareSystemInstance.getSoftwareSystem(), true), this.quote(""), this.quote(this.tags((Element)softwareSystemInstance)));
        this.formatModelItem((ModelItem)softwareSystemInstance);
        this.end();
    }

    private void format(ContainerInstance containerInstance) {
        this.start(this.id(containerInstance), "=", "containerInstance", this.id((ModelItem)containerInstance.getContainer(), true), this.quote(""), this.quote(this.tags((Element)containerInstance)));
        this.formatModelItem((ModelItem)containerInstance);
        this.end();
    }
}

