/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.PropertyHolder;
import com.structurizr.Workspace;
import com.structurizr.dsl.AdrsParser;
import com.structurizr.dsl.AutoLayoutParser;
import com.structurizr.dsl.BrandingDslContext;
import com.structurizr.dsl.BrandingParser;
import com.structurizr.dsl.CommentDslContext;
import com.structurizr.dsl.ComponentDslContext;
import com.structurizr.dsl.ComponentParser;
import com.structurizr.dsl.ComponentViewDslContext;
import com.structurizr.dsl.ComponentViewParser;
import com.structurizr.dsl.ConfigurationDslContext;
import com.structurizr.dsl.Constant;
import com.structurizr.dsl.ConstantParser;
import com.structurizr.dsl.ContainerDslContext;
import com.structurizr.dsl.ContainerInstanceDslContext;
import com.structurizr.dsl.ContainerInstanceParser;
import com.structurizr.dsl.ContainerParser;
import com.structurizr.dsl.ContainerViewDslContext;
import com.structurizr.dsl.ContainerViewParser;
import com.structurizr.dsl.CustomElementDslContext;
import com.structurizr.dsl.CustomElementParser;
import com.structurizr.dsl.CustomViewAnimationDslContext;
import com.structurizr.dsl.CustomViewAnimationStepParser;
import com.structurizr.dsl.CustomViewContentParser;
import com.structurizr.dsl.CustomViewDslContext;
import com.structurizr.dsl.CustomViewParser;
import com.structurizr.dsl.DeploymentEnvironment;
import com.structurizr.dsl.DeploymentEnvironmentDslContext;
import com.structurizr.dsl.DeploymentEnvironmentParser;
import com.structurizr.dsl.DeploymentGroup;
import com.structurizr.dsl.DeploymentGroupParser;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.DeploymentNodeParser;
import com.structurizr.dsl.DeploymentViewAnimationDslContext;
import com.structurizr.dsl.DeploymentViewAnimationStepParser;
import com.structurizr.dsl.DeploymentViewContentParser;
import com.structurizr.dsl.DeploymentViewDslContext;
import com.structurizr.dsl.DeploymentViewParser;
import com.structurizr.dsl.DocsParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.DslParserContext;
import com.structurizr.dsl.DslUtils;
import com.structurizr.dsl.DynamicViewContentParser;
import com.structurizr.dsl.DynamicViewDslContext;
import com.structurizr.dsl.DynamicViewParallelSequenceDslContext;
import com.structurizr.dsl.DynamicViewParser;
import com.structurizr.dsl.ElementGroup;
import com.structurizr.dsl.ElementStyleDslContext;
import com.structurizr.dsl.ElementStyleParser;
import com.structurizr.dsl.EnterpriseDslContext;
import com.structurizr.dsl.EnterpriseParser;
import com.structurizr.dsl.ExplicitRelationshipParser;
import com.structurizr.dsl.ExternalScriptDslContext;
import com.structurizr.dsl.FileUtils;
import com.structurizr.dsl.FilteredViewParser;
import com.structurizr.dsl.GroupParser;
import com.structurizr.dsl.GroupableDslContext;
import com.structurizr.dsl.HealthCheckParser;
import com.structurizr.dsl.IdentifierScope;
import com.structurizr.dsl.IdentifierScopeParser;
import com.structurizr.dsl.IdentifiersRegister;
import com.structurizr.dsl.ImplicitRelationshipParser;
import com.structurizr.dsl.ImpliedRelationshipsParser;
import com.structurizr.dsl.IncludeParser;
import com.structurizr.dsl.IncludedDslContext;
import com.structurizr.dsl.InfrastructureNodeDslContext;
import com.structurizr.dsl.InfrastructureNodeParser;
import com.structurizr.dsl.InlineScriptDslContext;
import com.structurizr.dsl.ModelDslContext;
import com.structurizr.dsl.ModelItemDslContext;
import com.structurizr.dsl.ModelItemParser;
import com.structurizr.dsl.ModelItemPerspectivesDslContext;
import com.structurizr.dsl.PersonDslContext;
import com.structurizr.dsl.PersonParser;
import com.structurizr.dsl.PluginDslContext;
import com.structurizr.dsl.PluginParser;
import com.structurizr.dsl.PropertiesDslContext;
import com.structurizr.dsl.PropertyParser;
import com.structurizr.dsl.RefParser;
import com.structurizr.dsl.RelationshipDslContext;
import com.structurizr.dsl.RelationshipStyleDslContext;
import com.structurizr.dsl.RelationshipStyleParser;
import com.structurizr.dsl.ScriptParser;
import com.structurizr.dsl.SoftwareSystemDslContext;
import com.structurizr.dsl.SoftwareSystemInstanceDslContext;
import com.structurizr.dsl.SoftwareSystemInstanceParser;
import com.structurizr.dsl.SoftwareSystemParser;
import com.structurizr.dsl.StaticStructureElementInstanceDslContext;
import com.structurizr.dsl.StaticViewAnimationDslContext;
import com.structurizr.dsl.StaticViewAnimationStepParser;
import com.structurizr.dsl.StaticViewContentParser;
import com.structurizr.dsl.StaticViewDslContext;
import com.structurizr.dsl.StructurizrDslParserException;
import com.structurizr.dsl.StructurizrDslTokens;
import com.structurizr.dsl.StylesDslContext;
import com.structurizr.dsl.SystemContextViewDslContext;
import com.structurizr.dsl.SystemContextViewParser;
import com.structurizr.dsl.SystemLandscapeViewDslContext;
import com.structurizr.dsl.SystemLandscapeViewParser;
import com.structurizr.dsl.TerminologyDslContext;
import com.structurizr.dsl.TerminologyParser;
import com.structurizr.dsl.ThemeParser;
import com.structurizr.dsl.Tokenizer;
import com.structurizr.dsl.Tokens;
import com.structurizr.dsl.UserRoleParser;
import com.structurizr.dsl.UsersDslContext;
import com.structurizr.dsl.ViewDslContext;
import com.structurizr.dsl.ViewParser;
import com.structurizr.dsl.ViewsDslContext;
import com.structurizr.dsl.WorkspaceDslContext;
import com.structurizr.dsl.WorkspaceParser;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.CustomView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class StructurizrDslParser
extends StructurizrDslTokens {
    private static final String BOM = "\ufeff";
    private static final Pattern EMPTY_LINE_PATTERN = Pattern.compile("^\\s*");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^\\s*?(//|#).*$");
    private static final String MULTI_LINE_COMMENT_START_TOKEN = "/*";
    private static final String MULTI_LINE_COMMENT_END_TOKEN = "*/";
    private static final Pattern STRING_SUBSTITUTION_PATTERN = Pattern.compile("(\\$\\{[a-zA-Z0-9-_.]+?})");
    private IdentifierScope identifierScope = IdentifierScope.Flat;
    private Stack<DslContext> contextStack;
    private Set<String> parsedTokens = new HashSet<String>();
    private IdentifiersRegister identifiersRegister;
    private Map<String, Constant> constants;
    private List<String> dslSourceLines = new ArrayList<String>();
    private Workspace workspace;
    private boolean extendingWorkspace = false;
    private boolean restricted = false;

    public StructurizrDslParser() {
        this.contextStack = new Stack();
        this.identifiersRegister = new IdentifiersRegister();
        this.constants = new HashMap<String, Constant>();
    }

    public IdentifierScope getIdentifierScope() {
        return this.identifierScope;
    }

    public void setIdentifierScope(IdentifierScope identifierScope) {
        if (identifierScope == null) {
            identifierScope = IdentifierScope.Flat;
        }
        this.identifierScope = identifierScope;
        this.identifiersRegister.setIdentifierScope(identifierScope);
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public Workspace getWorkspace() {
        if (this.workspace != null) {
            DslUtils.setDsl(this.workspace, this.getParsedDsl());
        }
        return this.workspace;
    }

    private String getParsedDsl() {
        StringBuilder buf = new StringBuilder();
        for (String line : this.dslSourceLines) {
            buf.append(line);
            buf.append(System.lineSeparator());
        }
        return buf.toString();
    }

    void parse(DslParserContext context, File path) throws StructurizrDslParserException {
        this.parse(path);
        context.copyFrom(this.identifiersRegister);
    }

    public void parse(File path) throws StructurizrDslParserException {
        if (path == null) {
            throw new StructurizrDslParserException("A file must be specified");
        }
        if (!path.exists()) {
            throw new StructurizrDslParserException("The file at " + path.getAbsolutePath() + " does not exist");
        }
        List<File> files = FileUtils.findFiles(path);
        try {
            for (File file : files) {
                this.parse(Files.readAllLines(file.toPath(), StandardCharsets.UTF_8), file);
            }
        }
        catch (IOException e) {
            throw new StructurizrDslParserException(e.getMessage());
        }
    }

    void parse(DslParserContext context, String dsl) throws StructurizrDslParserException {
        this.parse(dsl);
        context.copyFrom(this.identifiersRegister);
    }

    public void parse(String dsl) throws StructurizrDslParserException {
        if (StringUtils.isNullOrEmpty((String)dsl)) {
            throw new StructurizrDslParserException("A DSL fragment must be specified");
        }
        List<String> lines = Arrays.asList(dsl.split("\\r?\\n"));
        this.parse(lines, new File("."));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parse(List<String> lines, File dslFile) throws StructurizrDslParserException {
        int lineNumber = 1;
        for (String line : lines) {
            boolean includeInDslSourceLines = true;
            if (line.startsWith(BOM)) {
                line = line.substring(1);
            }
            try {
                if (!EMPTY_LINE_PATTERN.matcher(line).matches() && !COMMENT_PATTERN.matcher(line).matches()) {
                    if (this.inContext(InlineScriptDslContext.class)) {
                        if ("}".equals(line.trim())) {
                            this.endContext();
                        } else {
                            this.getContext(InlineScriptDslContext.class).addLine(line);
                        }
                    } else {
                        List<String> listOfTokens = new Tokenizer().tokenize(line);
                        listOfTokens = listOfTokens.stream().map(this::substituteStrings).collect(Collectors.toList());
                        Tokens tokens = new Tokens(listOfTokens);
                        String identifier = null;
                        if (tokens.size() > 3 && "=".equals(tokens.get(1))) {
                            identifier = tokens.get(0);
                            this.identifiersRegister.validateIdentifierName(identifier);
                            tokens = new Tokens(listOfTokens.subList(2, listOfTokens.size()));
                        }
                        String firstToken = tokens.get(0);
                        if (!line.trim().startsWith(MULTI_LINE_COMMENT_START_TOKEN) || !line.trim().endsWith(MULTI_LINE_COMMENT_END_TOKEN)) {
                            if (firstToken.startsWith(MULTI_LINE_COMMENT_START_TOKEN)) {
                                this.startContext(new CommentDslContext());
                            } else if (this.inContext(CommentDslContext.class) && line.trim().endsWith(MULTI_LINE_COMMENT_END_TOKEN)) {
                                this.endContext();
                            } else if (!this.inContext(CommentDslContext.class)) {
                                if ("}".equals(tokens.get(0))) {
                                    this.endContext();
                                } else if ("!include".equalsIgnoreCase(firstToken)) {
                                    if (!this.restricted || tokens.get(1).startsWith("https://")) {
                                        IncludedDslContext includedDslContext = new IncludedDslContext(dslFile);
                                        new IncludeParser().parse(includedDslContext, tokens);
                                        this.parse(includedDslContext.getLines(), includedDslContext.getFile());
                                        includeInDslSourceLines = false;
                                    }
                                } else if (tokens.size() > 2 && "->".equals(tokens.get(1)) && (this.inContext(ModelDslContext.class) || this.inContext(EnterpriseDslContext.class) || this.inContext(CustomElementDslContext.class) || this.inContext(PersonDslContext.class) || this.inContext(SoftwareSystemDslContext.class) || this.inContext(ContainerDslContext.class) || this.inContext(ComponentDslContext.class) || this.inContext(DeploymentEnvironmentDslContext.class) || this.inContext(DeploymentNodeDslContext.class) || this.inContext(InfrastructureNodeDslContext.class) || this.inContext(SoftwareSystemInstanceDslContext.class) || this.inContext(ContainerInstanceDslContext.class))) {
                                    Relationship relationship = new ExplicitRelationshipParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new RelationshipDslContext(relationship));
                                    }
                                    this.registerIdentifier(identifier, relationship);
                                } else if (tokens.size() >= 2 && "->".equals(tokens.get(0)) && (this.inContext(CustomElementDslContext.class) || this.inContext(PersonDslContext.class) || this.inContext(SoftwareSystemDslContext.class) || this.inContext(ContainerDslContext.class) || this.inContext(ComponentDslContext.class) || this.inContext(DeploymentNodeDslContext.class) || this.inContext(InfrastructureNodeDslContext.class) || this.inContext(SoftwareSystemInstanceDslContext.class) || this.inContext(ContainerInstanceDslContext.class))) {
                                    Relationship relationship = new ImplicitRelationshipParser().parse(this.getContext(ModelItemDslContext.class), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new RelationshipDslContext(relationship));
                                    }
                                    this.registerIdentifier(identifier, relationship);
                                } else if ("!ref".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                    ModelItem modelItem = new RefParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        if (modelItem instanceof Person) {
                                            this.startContext(new PersonDslContext((Person)modelItem));
                                        } else if (modelItem instanceof SoftwareSystem) {
                                            this.startContext(new SoftwareSystemDslContext((SoftwareSystem)modelItem));
                                        } else if (modelItem instanceof Container) {
                                            this.startContext(new ContainerDslContext((Container)modelItem));
                                        } else if (modelItem instanceof Component) {
                                            this.startContext(new ComponentDslContext((Component)modelItem));
                                        } else if (modelItem instanceof DeploymentEnvironment) {
                                            this.startContext(new DeploymentEnvironmentDslContext(((DeploymentEnvironment)modelItem).getName()));
                                        } else if (modelItem instanceof DeploymentNode) {
                                            this.startContext(new DeploymentNodeDslContext((DeploymentNode)modelItem));
                                        } else if (modelItem instanceof InfrastructureNode) {
                                            this.startContext(new InfrastructureNodeDslContext((InfrastructureNode)modelItem));
                                        } else if (modelItem instanceof SoftwareSystemInstance) {
                                            this.startContext(new SoftwareSystemInstanceDslContext((SoftwareSystemInstance)modelItem));
                                        } else if (modelItem instanceof ContainerInstance) {
                                            this.startContext(new ContainerInstanceDslContext((ContainerInstance)modelItem));
                                        } else if (modelItem instanceof Relationship) {
                                            this.startContext(new RelationshipDslContext((Relationship)modelItem));
                                        }
                                    }
                                    if (!StringUtils.isNullOrEmpty((String)identifier)) {
                                        if (modelItem instanceof Element) {
                                            this.registerIdentifier(identifier, (Element)modelItem);
                                        } else if (modelItem instanceof Relationship) {
                                            this.registerIdentifier(identifier, (Relationship)modelItem);
                                        }
                                    }
                                } else if ("element".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                    CustomElement customElement = new CustomElementParser().parse(this.getContext(GroupableDslContext.class), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new CustomElementDslContext(customElement));
                                    }
                                    this.registerIdentifier(identifier, (Element)customElement);
                                } else if ("person".equalsIgnoreCase(firstToken) && (this.inContext(ModelDslContext.class) || this.inContext(EnterpriseDslContext.class))) {
                                    Person person = new PersonParser().parse(this.getContext(GroupableDslContext.class), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new PersonDslContext(person));
                                    }
                                    this.registerIdentifier(identifier, (Element)person);
                                } else if ("softwareSystem".equalsIgnoreCase(firstToken) && (this.inContext(ModelDslContext.class) || this.inContext(EnterpriseDslContext.class))) {
                                    SoftwareSystem softwareSystem = new SoftwareSystemParser().parse(this.getContext(GroupableDslContext.class), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new SoftwareSystemDslContext(softwareSystem));
                                    }
                                    this.registerIdentifier(identifier, (Element)softwareSystem);
                                } else if ("container".equalsIgnoreCase(firstToken) && this.inContext(SoftwareSystemDslContext.class)) {
                                    Container container = new ContainerParser().parse(this.getContext(SoftwareSystemDslContext.class), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new ContainerDslContext(container));
                                    }
                                    this.registerIdentifier(identifier, (Element)container);
                                } else if ("component".equalsIgnoreCase(firstToken) && this.inContext(ContainerDslContext.class)) {
                                    Component component = new ComponentParser().parse(this.getContext(ContainerDslContext.class), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new ComponentDslContext(component));
                                    }
                                    this.registerIdentifier(identifier, (Element)component);
                                } else if ("group".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class) && !this.getContext(ModelDslContext.class).hasGroup()) {
                                    ElementGroup elementGroup = new GroupParser().parse(tokens.withoutContextStartToken());
                                    this.startContext(new ModelDslContext(elementGroup));
                                    this.registerIdentifier(identifier, elementGroup);
                                } else if ("group".equalsIgnoreCase(firstToken) && this.inContext(EnterpriseDslContext.class) && !this.getContext(EnterpriseDslContext.class).hasGroup()) {
                                    ElementGroup elementGroup = new GroupParser().parse(tokens.withoutContextStartToken());
                                    this.startContext(new EnterpriseDslContext(elementGroup));
                                    this.registerIdentifier(identifier, elementGroup);
                                } else if ("group".equalsIgnoreCase(firstToken) && this.inContext(SoftwareSystemDslContext.class) && !this.getContext(SoftwareSystemDslContext.class).hasGroup()) {
                                    ElementGroup elementGroup = new GroupParser().parse(tokens.withoutContextStartToken());
                                    SoftwareSystem softwareSystem = this.getContext(SoftwareSystemDslContext.class).getSoftwareSystem();
                                    elementGroup.setParent((Element)softwareSystem);
                                    this.startContext(new SoftwareSystemDslContext(softwareSystem, elementGroup));
                                    this.registerIdentifier(identifier, elementGroup);
                                } else if ("group".equalsIgnoreCase(firstToken) && this.inContext(ContainerDslContext.class) && !this.getContext(ContainerDslContext.class).hasGroup()) {
                                    ElementGroup elementGroup = new GroupParser().parse(tokens.withoutContextStartToken());
                                    Container container = this.getContext(ContainerDslContext.class).getContainer();
                                    elementGroup.setParent((Element)container);
                                    this.startContext(new ContainerDslContext(container, elementGroup));
                                    this.registerIdentifier(identifier, elementGroup);
                                } else if ("tags".equalsIgnoreCase(firstToken) && this.inContext(ModelItemDslContext.class) && !this.getContext(ModelItemDslContext.class).hasGroup()) {
                                    new ModelItemParser().parseTags(this.getContext(ModelItemDslContext.class), tokens);
                                } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(ModelItemDslContext.class) && this.getContext(ModelItemDslContext.class).getModelItem() instanceof Element && !this.getContext(ModelItemDslContext.class).hasGroup()) {
                                    new ModelItemParser().parseDescription(this.getContext(ModelItemDslContext.class), tokens);
                                } else if ("technology".equalsIgnoreCase(firstToken) && this.inContext(ContainerDslContext.class) && !this.getContext(ContainerDslContext.class).hasGroup()) {
                                    new ContainerParser().parseTechnology(this.getContext(ContainerDslContext.class), tokens);
                                } else if ("technology".equalsIgnoreCase(firstToken) && this.inContext(ComponentDslContext.class) && !this.getContext(ComponentDslContext.class).hasGroup()) {
                                    new ComponentParser().parseTechnology(this.getContext(ComponentDslContext.class), tokens);
                                } else if ("technology".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                    new DeploymentNodeParser().parseTechnology(this.getContext(DeploymentNodeDslContext.class), tokens);
                                } else if ("technology".equalsIgnoreCase(firstToken) && this.inContext(InfrastructureNodeDslContext.class)) {
                                    new InfrastructureNodeParser().parseTechnology(this.getContext(InfrastructureNodeDslContext.class), tokens);
                                } else if ("instances".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                    new DeploymentNodeParser().parseInstances(this.getContext(DeploymentNodeDslContext.class), tokens);
                                } else if ("url".equalsIgnoreCase(firstToken) && this.inContext(ModelItemDslContext.class) && !this.getContext(ModelItemDslContext.class).hasGroup()) {
                                    new ModelItemParser().parseUrl(this.getContext(ModelItemDslContext.class), tokens);
                                } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                    this.startContext(new PropertiesDslContext((PropertyHolder)this.workspace));
                                } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ConfigurationDslContext.class) && !this.getContext(ModelItemDslContext.class).hasGroup()) {
                                    this.startContext(new PropertiesDslContext((PropertyHolder)this.getContext(ConfigurationDslContext.class).getWorkspace()));
                                } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ModelItemDslContext.class) && !this.getContext(ModelItemDslContext.class).hasGroup()) {
                                    this.startContext(new PropertiesDslContext((PropertyHolder)this.getContext(ModelItemDslContext.class).getModelItem()));
                                } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    this.startContext(new PropertiesDslContext((PropertyHolder)this.workspace.getViews().getConfiguration()));
                                } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ViewDslContext.class)) {
                                    this.startContext(new PropertiesDslContext((PropertyHolder)this.getContext(ViewDslContext.class).getView()));
                                } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    this.startContext(new PropertiesDslContext((PropertyHolder)this.getContext(ElementStyleDslContext.class).getStyle()));
                                } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                    this.startContext(new PropertiesDslContext((PropertyHolder)this.getContext(RelationshipStyleDslContext.class).getStyle()));
                                } else if (this.inContext(PropertiesDslContext.class)) {
                                    new PropertyParser().parse(this.getContext(PropertiesDslContext.class), tokens);
                                } else if ("perspectives".equalsIgnoreCase(firstToken) && this.inContext(ModelItemDslContext.class) && !this.getContext(ModelItemDslContext.class).hasGroup()) {
                                    this.startContext(new ModelItemPerspectivesDslContext(this.getContext(ModelItemDslContext.class).getModelItem()));
                                } else if (this.inContext(ModelItemPerspectivesDslContext.class)) {
                                    new ModelItemParser().parsePerspective(this.getContext(ModelItemPerspectivesDslContext.class), tokens);
                                } else if ("workspace".equalsIgnoreCase(firstToken) && this.contextStack.empty()) {
                                    if (this.parsedTokens.contains("workspace")) {
                                        throw new RuntimeException("Multiple workspaces are not permitted in a DSL definition");
                                    }
                                    DslParserContext dslParserContext = new DslParserContext(dslFile, this.restricted);
                                    dslParserContext.setIdentifierRegister(this.identifiersRegister);
                                    this.workspace = new WorkspaceParser().parse(dslParserContext, tokens.withoutContextStartToken());
                                    this.extendingWorkspace = !this.workspace.getModel().isEmpty();
                                    this.startContext(new WorkspaceDslContext());
                                    this.parsedTokens.add("workspace");
                                } else if ("!impliedRelationships".equalsIgnoreCase(firstToken) || "!impliedRelationships".substring(1).equalsIgnoreCase(firstToken)) {
                                    new ImpliedRelationshipsParser().parse(this.getContext(), tokens);
                                } else if ("name".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                    new WorkspaceParser().parseName(this.getContext(), tokens);
                                } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                    new WorkspaceParser().parseDescription(this.getContext(), tokens);
                                } else if ("model".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                    if (this.parsedTokens.contains("model")) {
                                        throw new RuntimeException("Multiple models are not permitted in a DSL definition");
                                    }
                                    this.startContext(new ModelDslContext());
                                    this.parsedTokens.add("model");
                                } else if ("views".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                    if (this.parsedTokens.contains("views")) {
                                        throw new RuntimeException("Multiple view sets are not permitted in a DSL definition");
                                    }
                                    this.startContext(new ViewsDslContext());
                                    this.parsedTokens.add("views");
                                } else if ("branding".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    this.startContext(new BrandingDslContext(dslFile));
                                } else if ("logo".equalsIgnoreCase(firstToken) && this.inContext(BrandingDslContext.class)) {
                                    new BrandingParser().parseLogo(this.getContext(BrandingDslContext.class), tokens, this.restricted);
                                } else if ("font".equalsIgnoreCase(firstToken) && this.inContext(BrandingDslContext.class)) {
                                    new BrandingParser().parseFont(this.getContext(BrandingDslContext.class), tokens);
                                } else if ("styles".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    this.startContext(new StylesDslContext());
                                } else if ("element".equalsIgnoreCase(firstToken) && this.inContext(StylesDslContext.class)) {
                                    ElementStyle elementStyle = new ElementStyleParser().parseElementStyle(this.getContext(), tokens.withoutContextStartToken());
                                    this.startContext(new ElementStyleDslContext(elementStyle, dslFile));
                                } else if ("background".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseBackground(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if (("colour".equalsIgnoreCase(firstToken) || "color".equalsIgnoreCase(firstToken)) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseColour(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if ("stroke".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseStroke(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if ("strokeWidth".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseStrokeWidth(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if ("shape".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseShape(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if ("border".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseBorder(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if ("opacity".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseOpacity(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if ("width".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseWidth(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if ("height".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseHeight(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if ("fontSize".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseFontSize(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if ("metadata".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseMetadata(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseDescription(this.getContext(ElementStyleDslContext.class), tokens);
                                } else if ("icon".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                    new ElementStyleParser().parseIcon(this.getContext(ElementStyleDslContext.class), tokens, this.restricted);
                                } else if ("relationship".equalsIgnoreCase(firstToken) && this.inContext(StylesDslContext.class)) {
                                    RelationshipStyle relationshipStyle = new RelationshipStyleParser().parseRelationshipStyle(this.getContext(), tokens.withoutContextStartToken());
                                    this.startContext(new RelationshipStyleDslContext(relationshipStyle));
                                } else if ("thickness".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                    new RelationshipStyleParser().parseThickness(this.getContext(RelationshipStyleDslContext.class), tokens);
                                } else if (("colour".equalsIgnoreCase(firstToken) || "color".equalsIgnoreCase(firstToken)) && this.inContext(RelationshipStyleDslContext.class)) {
                                    new RelationshipStyleParser().parseColour(this.getContext(RelationshipStyleDslContext.class), tokens);
                                } else if ("dashed".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                    new RelationshipStyleParser().parseDashed(this.getContext(RelationshipStyleDslContext.class), tokens);
                                } else if ("opacity".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                    new RelationshipStyleParser().parseOpacity(this.getContext(RelationshipStyleDslContext.class), tokens);
                                } else if ("width".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                    new RelationshipStyleParser().parseWidth(this.getContext(RelationshipStyleDslContext.class), tokens);
                                } else if ("fontSize".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                    new RelationshipStyleParser().parseFontSize(this.getContext(RelationshipStyleDslContext.class), tokens);
                                } else if ("position".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                    new RelationshipStyleParser().parsePosition(this.getContext(RelationshipStyleDslContext.class), tokens);
                                } else if ("style".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                    new RelationshipStyleParser().parseLineStyle(this.getContext(RelationshipStyleDslContext.class), tokens);
                                } else if ("routing".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                    new RelationshipStyleParser().parseRouting(this.getContext(RelationshipStyleDslContext.class), tokens);
                                } else if ("enterprise".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                    new EnterpriseParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    this.startContext(new EnterpriseDslContext());
                                } else if ("deploymentEnvironment".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                    String string = new DeploymentEnvironmentParser().parse(tokens.withoutContextStartToken());
                                    this.startContext(new DeploymentEnvironmentDslContext(string));
                                    this.registerIdentifier(identifier, new DeploymentEnvironment(string));
                                } else if ("deploymentGroup".equalsIgnoreCase(firstToken) && this.inContext(DeploymentEnvironmentDslContext.class)) {
                                    String string = new DeploymentGroupParser().parse(tokens.withoutContextStartToken());
                                    this.registerIdentifier(identifier, new DeploymentGroup(string));
                                } else if ("deploymentNode".equalsIgnoreCase(firstToken) && (this.inContext(DeploymentEnvironmentDslContext.class) || this.inContext(DeploymentNodeDslContext.class))) {
                                    DeploymentNode deploymentNode = new DeploymentNodeParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new DeploymentNodeDslContext(deploymentNode));
                                    }
                                    this.registerIdentifier(identifier, (Element)deploymentNode);
                                } else if ("infrastructureNode".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                    InfrastructureNode infrastructureNode = new InfrastructureNodeParser().parse(this.getContext(DeploymentNodeDslContext.class), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new InfrastructureNodeDslContext(infrastructureNode));
                                    }
                                    this.registerIdentifier(identifier, (Element)infrastructureNode);
                                } else if ("softwareSystemInstance".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                    SoftwareSystemInstance softwareSystemInstance = new SoftwareSystemInstanceParser().parse(this.getContext(DeploymentNodeDslContext.class), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new SoftwareSystemInstanceDslContext(softwareSystemInstance));
                                    }
                                    this.registerIdentifier(identifier, (Element)softwareSystemInstance);
                                } else if ("containerInstance".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                    ContainerInstance containerInstance = new ContainerInstanceParser().parse(this.getContext(DeploymentNodeDslContext.class), tokens.withoutContextStartToken());
                                    if (this.shouldStartContext(tokens)) {
                                        this.startContext(new ContainerInstanceDslContext(containerInstance));
                                    }
                                    this.registerIdentifier(identifier, (Element)containerInstance);
                                } else if ("healthCheck".equalsIgnoreCase(firstToken) && this.inContext(StaticStructureElementInstanceDslContext.class)) {
                                    new HealthCheckParser().parse(this.getContext(StaticStructureElementInstanceDslContext.class), tokens.withoutContextStartToken());
                                } else if ("custom".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    CustomView customView = new CustomViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    this.startContext(new CustomViewDslContext(customView));
                                } else if ("systemLandscape".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    SystemLandscapeView systemLandscapeView = new SystemLandscapeViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    this.startContext(new SystemLandscapeViewDslContext(systemLandscapeView));
                                } else if ("systemContext".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    SystemContextView systemContextView = new SystemContextViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    this.startContext(new SystemContextViewDslContext(systemContextView));
                                } else if ("container".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    ContainerView containerView = new ContainerViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    this.startContext(new ContainerViewDslContext(containerView));
                                } else if ("component".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    ComponentView componentView = new ComponentViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    this.startContext(new ComponentViewDslContext(componentView));
                                } else if ("dynamic".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    DynamicView dynamicView = new DynamicViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    this.startContext(new DynamicViewDslContext(dynamicView));
                                } else if ("deployment".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    DeploymentView deploymentView = new DeploymentViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    this.startContext(new DeploymentViewDslContext(deploymentView));
                                } else if ("filtered".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    new FilteredViewParser().parse(this.getContext(), tokens);
                                } else if ("{".equalsIgnoreCase(firstToken) && this.inContext(DynamicViewDslContext.class)) {
                                    this.startContext(new DynamicViewParallelSequenceDslContext(this.getContext(DynamicViewDslContext.class)));
                                } else if ("include".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                    new CustomViewContentParser().parseInclude(this.getContext(CustomViewDslContext.class), tokens);
                                } else if ("exclude".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                    new CustomViewContentParser().parseExclude(this.getContext(CustomViewDslContext.class), tokens);
                                } else if ("animationStep".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                    new CustomViewAnimationStepParser().parse(this.getContext(CustomViewDslContext.class), tokens);
                                } else if ("animation".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                    this.startContext(new CustomViewAnimationDslContext(this.getContext(CustomViewDslContext.class).getCustomView()));
                                } else if (this.inContext(CustomViewAnimationDslContext.class)) {
                                    new CustomViewAnimationStepParser().parse(this.getContext(CustomViewAnimationDslContext.class), tokens);
                                } else if ("include".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                    new StaticViewContentParser().parseInclude(this.getContext(StaticViewDslContext.class), tokens);
                                } else if ("exclude".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                    new StaticViewContentParser().parseExclude(this.getContext(StaticViewDslContext.class), tokens);
                                } else if ("animationStep".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                    new StaticViewAnimationStepParser().parse(this.getContext(StaticViewDslContext.class), tokens);
                                } else if ("animation".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                    this.startContext(new StaticViewAnimationDslContext(this.getContext(StaticViewDslContext.class).getView()));
                                } else if (this.inContext(StaticViewAnimationDslContext.class)) {
                                    new StaticViewAnimationStepParser().parse(this.getContext(StaticViewAnimationDslContext.class), tokens);
                                } else if ("include".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                    new DeploymentViewContentParser().parseInclude(this.getContext(DeploymentViewDslContext.class), tokens);
                                } else if ("exclude".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                    new DeploymentViewContentParser().parseExclude(this.getContext(DeploymentViewDslContext.class), tokens);
                                } else if ("animationStep".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                    new DeploymentViewAnimationStepParser().parse(this.getContext(DeploymentViewDslContext.class), tokens);
                                } else if ("animation".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                    this.startContext(new DeploymentViewAnimationDslContext(this.getContext(DeploymentViewDslContext.class).getView()));
                                } else if (this.inContext(DeploymentViewAnimationDslContext.class)) {
                                    new DeploymentViewAnimationStepParser().parse(this.getContext(DeploymentViewAnimationDslContext.class), tokens);
                                } else if ("autolayout".equalsIgnoreCase(firstToken) && this.inContext(ViewDslContext.class)) {
                                    new AutoLayoutParser().parse(this.getContext(ViewDslContext.class), tokens);
                                } else if ("title".equalsIgnoreCase(firstToken) && this.inContext(ViewDslContext.class)) {
                                    new ViewParser().parseTitle(this.getContext(ViewDslContext.class), tokens);
                                } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(ViewDslContext.class)) {
                                    new ViewParser().parseDescription(this.getContext(ViewDslContext.class), tokens);
                                } else if (this.inContext(DynamicViewDslContext.class)) {
                                    new DynamicViewContentParser().parseRelationship(this.getContext(DynamicViewDslContext.class), tokens);
                                } else if ("theme".equalsIgnoreCase(firstToken) && (this.inContext(ViewsDslContext.class) || this.inContext(StylesDslContext.class))) {
                                    new ThemeParser().parseTheme(this.getContext(), tokens);
                                } else if ("themes".equalsIgnoreCase(firstToken) && (this.inContext(ViewsDslContext.class) || this.inContext(StylesDslContext.class))) {
                                    new ThemeParser().parseThemes(this.getContext(), tokens);
                                } else if ("terminology".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                    this.startContext(new TerminologyDslContext());
                                } else if ("enterprise".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                    new TerminologyParser().parseEnterprise(this.getContext(), tokens);
                                } else if ("person".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                    new TerminologyParser().parsePerson(this.getContext(), tokens);
                                } else if ("softwareSystem".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                    new TerminologyParser().parseSoftwareSystem(this.getContext(), tokens);
                                } else if ("container".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                    new TerminologyParser().parseContainer(this.getContext(), tokens);
                                } else if ("component".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                    new TerminologyParser().parseComponent(this.getContext(), tokens);
                                } else if ("deploymentNode".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                    new TerminologyParser().parseDeploymentNode(this.getContext(), tokens);
                                } else if ("infrastructureNode".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                    new TerminologyParser().parseInfrastructureNode(this.getContext(), tokens);
                                } else if ("relationship".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                    new TerminologyParser().parseRelationship(this.getContext(), tokens);
                                } else if ("configuration".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                    this.startContext(new ConfigurationDslContext());
                                } else if ("users".equalsIgnoreCase(firstToken) && this.inContext(ConfigurationDslContext.class)) {
                                    this.startContext(new UsersDslContext());
                                } else if (this.inContext(UsersDslContext.class)) {
                                    new UserRoleParser().parse(this.getContext(), tokens);
                                } else if ("!docs".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                    if (!this.restricted) {
                                        new DocsParser().parse(this.getContext(WorkspaceDslContext.class), dslFile, tokens);
                                    }
                                } else if ("!docs".equalsIgnoreCase(firstToken) && this.inContext(SoftwareSystemDslContext.class)) {
                                    if (!this.restricted) {
                                        new DocsParser().parse(this.getContext(SoftwareSystemDslContext.class), dslFile, tokens);
                                    }
                                } else if ("!docs".equalsIgnoreCase(firstToken) && this.inContext(ContainerDslContext.class)) {
                                    if (!this.restricted) {
                                        new DocsParser().parse(this.getContext(ContainerDslContext.class), dslFile, tokens);
                                    }
                                } else if ("!adrs".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                    if (!this.restricted) {
                                        new AdrsParser().parse(this.getContext(WorkspaceDslContext.class), dslFile, tokens);
                                    }
                                } else if ("!adrs".equalsIgnoreCase(firstToken) && this.inContext(SoftwareSystemDslContext.class)) {
                                    if (!this.restricted) {
                                        new AdrsParser().parse(this.getContext(SoftwareSystemDslContext.class), dslFile, tokens);
                                    }
                                } else if ("!adrs".equalsIgnoreCase(firstToken) && this.inContext(ContainerDslContext.class)) {
                                    if (!this.restricted) {
                                        new AdrsParser().parse(this.getContext(ContainerDslContext.class), dslFile, tokens);
                                    }
                                } else if ("!constant".equalsIgnoreCase(firstToken)) {
                                    Constant constant = new ConstantParser().parse(this.getContext(), tokens);
                                    this.constants.put(constant.getName(), constant);
                                } else if ("!identifiers".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                    this.setIdentifierScope(new IdentifierScopeParser().parse(this.getContext(), tokens));
                                } else if ("!plugin".equalsIgnoreCase(firstToken)) {
                                    if (this.restricted) throw new StructurizrDslParserException("Plugins are not available");
                                    String string = new PluginParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                    this.startContext(new PluginDslContext(string, dslFile));
                                    if (!this.shouldStartContext(tokens)) {
                                        this.endContext();
                                    }
                                } else if (this.inContext(PluginDslContext.class)) {
                                    new PluginParser().parseParameter(this.getContext(PluginDslContext.class), tokens);
                                } else {
                                    if (!"!script".equalsIgnoreCase(firstToken)) throw new StructurizrDslParserException("Unexpected tokens");
                                    if (this.restricted) throw new StructurizrDslParserException("Scripts are not available");
                                    if (this.shouldStartContext(tokens)) {
                                        String string = new ScriptParser().parseInline(tokens.withoutContextStartToken());
                                        this.startContext(new InlineScriptDslContext(string));
                                    } else {
                                        String string = new ScriptParser().parseExternal(tokens);
                                        this.startContext(new ExternalScriptDslContext(dslFile, string));
                                        this.endContext();
                                    }
                                }
                            }
                        }
                    }
                }
                if (includeInDslSourceLines) {
                    this.dslSourceLines.add(line);
                }
                ++lineNumber;
            }
            catch (Exception e) {
                if (e.getMessage() == null) throw new StructurizrDslParserException(e.getClass().getSimpleName(), lineNumber, line);
                throw new StructurizrDslParserException(e.getMessage(), lineNumber, line);
            }
        }
    }

    private String substituteStrings(String token) {
        Matcher m = STRING_SUBSTITUTION_PATTERN.matcher(token);
        while (m.find()) {
            String environmentVariable;
            String before = m.group(0);
            String after = null;
            String name = before.substring(2, before.length() - 1);
            if (this.constants.containsKey(name)) {
                after = this.constants.get(name).getValue();
            } else if (!this.restricted && (environmentVariable = System.getenv().get(name)) != null) {
                after = environmentVariable;
            }
            if (after == null) continue;
            token = token.replace(before, after);
        }
        return token;
    }

    private boolean shouldStartContext(Tokens tokens) {
        return "{".equalsIgnoreCase(tokens.get(tokens.size() - 1));
    }

    private void startContext(DslContext context) {
        context.setWorkspace(this.workspace);
        context.setIdentifierRegister(this.identifiersRegister);
        context.setExtendingWorkspace(this.extendingWorkspace);
        this.contextStack.push(context);
    }

    private DslContext getContext() {
        if (!this.contextStack.empty()) {
            return this.contextStack.peek();
        }
        return null;
    }

    private <T> T getContext(Class<T> clazz) throws StructurizrDslParserException {
        if (this.inContext(clazz)) {
            return (T)this.contextStack.peek();
        }
        throw new StructurizrDslParserException("Expected " + clazz.getName() + " but got " + this.contextStack.peek().getClass().getName());
    }

    private void endContext() throws StructurizrDslParserException {
        if (this.contextStack.empty()) {
            throw new StructurizrDslParserException("Unexpected end of context");
        }
        DslContext context = this.contextStack.pop();
        context.end();
    }

    public IdentifiersRegister getIdentifiersRegister() {
        return this.identifiersRegister;
    }

    private void registerIdentifier(String identifier, Element element) {
        this.identifiersRegister.register(identifier, element);
    }

    private void registerIdentifier(String identifier, Relationship relationship) {
        this.identifiersRegister.register(identifier, relationship);
    }

    private boolean inContext(Class clazz) {
        if (this.contextStack.empty()) {
            return false;
        }
        return clazz.isAssignableFrom(this.contextStack.peek().getClass());
    }
}

