/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.Constant;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;

final class ConstantParser
extends AbstractParser {
    private static final String GRAMMAR = "!constant <name> <value>";
    private static final int NAME_INDEX = 1;
    private static final int VALUE_INDEX = 2;
    private static final String NAME_REGEX = "[a-zA-Z0-9-_.]+";

    ConstantParser() {
    }

    Constant parse(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(2)) {
            throw new RuntimeException("Too many tokens, expected: !constant <name> <value>");
        }
        if (!tokens.includes(2)) {
            throw new RuntimeException("Expected: !constant <name> <value>");
        }
        String name = tokens.get(1);
        String value = tokens.get(2);
        if (!name.matches(NAME_REGEX)) {
            throw new RuntimeException("Constant names must only contain the following characters: a-zA-Z0-9-_.");
        }
        return new Constant(name, value);
    }
}

