/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AbstractViewParser;
import com.structurizr.dsl.DeploymentEnvironment;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Element;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.DeploymentView;

final class DeploymentViewParser
extends AbstractViewParser {
    private static final String GRAMMAR = "deployment <*|software system identifier> <environment> [key] [description] {";
    private static final String VIEW_TYPE = "Deployment";
    private static final int SCOPE_IDENTIFIER_INDEX = 1;
    private static final int ENVIRONMENT_INDEX = 2;
    private static final int KEY_INDEX = 3;
    private static final int DESCRIPTION_INDEX = 4;

    DeploymentViewParser() {
    }

    DeploymentView parse(DslContext context, Tokens tokens) {
        DeploymentView view;
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: deployment <*|software system identifier> <environment> [key] [description] {");
        }
        if (!tokens.includes(2)) {
            throw new RuntimeException("Expected: deployment <*|software system identifier> <environment> [key] [description] {");
        }
        Workspace workspace = context.getWorkspace();
        String key = "";
        String scopeIdentifier = tokens.get(1);
        String environment = tokens.get(2);
        if (context.getElement(environment) != null && context.getElement(environment) instanceof DeploymentEnvironment) {
            environment = context.getElement(environment).getName();
        }
        String env = environment;
        if (context.getWorkspace().getModel().getDeploymentNodes().stream().noneMatch(dn -> dn.getEnvironment().equals(env))) {
            throw new RuntimeException("The environment \"" + environment + "\" does not exist");
        }
        String description = "";
        if (tokens.includes(4)) {
            description = tokens.get(4);
        }
        if ("*".equals(scopeIdentifier)) {
            key = tokens.includes(3) ? tokens.get(3) : this.generateViewKey(workspace, VIEW_TYPE);
            this.validateViewKey(key);
            view = workspace.getViews().createDeploymentView(key, description);
        } else {
            Element element = context.getElement(scopeIdentifier);
            if (element == null) {
                throw new RuntimeException("The software system \"" + scopeIdentifier + "\" does not exist");
            }
            if (element instanceof SoftwareSystem) {
                key = tokens.includes(3) ? tokens.get(3) : this.generateViewKey(workspace, VIEW_TYPE);
                this.validateViewKey(key);
                view = workspace.getViews().createDeploymentView((SoftwareSystem)element, key, description);
            } else {
                throw new RuntimeException("The element \"" + scopeIdentifier + "\" is not a software system");
            }
        }
        view.setEnvironment(environment);
        return view;
    }
}

