/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AbstractViewParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.util.StringUtils;
import com.structurizr.view.FilterMode;
import com.structurizr.view.FilteredView;
import com.structurizr.view.StaticView;
import java.util.HashSet;

final class FilteredViewParser
extends AbstractViewParser {
    private static final String GRAMMAR = "filtered <baseKey> <include|exclude> <tags> [key] [description]";
    private static final String VIEW_TYPE = "Filtered";
    private static final int BASE_KEY_INDEX = 1;
    private static final int MODE_INDEX = 2;
    private static final int TAGS_INDEX = 3;
    private static final int KEY_INDEX = 4;
    private static final int DESCRIPTION_INDEX = 5;
    private static final String FILTER_MODE_INCLUDE = "include";
    private static final String FILTER_MODE_EXCLUDE = "exclude";

    FilteredViewParser() {
    }

    FilteredView parse(DslContext context, Tokens tokens) {
        FilterMode filterMode;
        if (tokens.hasMoreThan(5)) {
            throw new RuntimeException("Too many tokens, expected: filtered <baseKey> <include|exclude> <tags> [key] [description]");
        }
        if (!tokens.includes(3)) {
            throw new RuntimeException("Expected: filtered <baseKey> <include|exclude> <tags> [key] [description]");
        }
        Workspace workspace = context.getWorkspace();
        String baseKey = tokens.get(1);
        String mode = tokens.get(2);
        String tagsAsString = tokens.get(3);
        HashSet<String> tags = new HashSet<String>();
        for (String tag : tagsAsString.split(",")) {
            if (StringUtils.isNullOrEmpty((String)tag)) continue;
            tags.add(tag.trim());
        }
        String description = "";
        if (tokens.includes(5)) {
            description = tokens.get(5);
        }
        if (FILTER_MODE_INCLUDE.equalsIgnoreCase(mode)) {
            filterMode = FilterMode.Include;
        } else if (FILTER_MODE_EXCLUDE.equalsIgnoreCase(mode)) {
            filterMode = FilterMode.Exclude;
        } else {
            throw new RuntimeException("Filter mode should be include or exclude");
        }
        if (workspace.getViews().getViews().stream().noneMatch(v -> v.getKey().equals(baseKey))) {
            throw new RuntimeException("The view \"" + baseKey + "\" does not exist");
        }
        StaticView baseView = workspace.getViews().getViews().stream().filter(v -> v instanceof StaticView && v.getKey().equals(baseKey)).findFirst().orElse(null);
        if (baseView == null) {
            throw new RuntimeException("The view \"" + baseKey + "\" must be a System Landscape, System Context, Container, or Component view");
        }
        String key = tokens.includes(4) ? tokens.get(4) : this.generateViewKey(workspace, VIEW_TYPE);
        this.validateViewKey(key);
        return workspace.getViews().createFilteredView(baseView, key, description, filterMode, tags.toArray(new String[0]));
    }
}

