/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AbstractViewParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Element;
import com.structurizr.view.ImageView;

class ImageViewParser
extends AbstractViewParser {
    private static final String GRAMMAR = "image <*|element identifier> [key] {";
    private static final String VIEW_TYPE = "Image";
    private static final int SCOPE_IDENTIFIER_INDEX = 1;
    private static final int KEY_INDEX = 2;
    private static final String WILDCARD = "*";

    ImageViewParser() {
    }

    ImageView parse(DslContext context, Tokens tokens) {
        ImageView view;
        Workspace workspace = context.getWorkspace();
        String key = "";
        if (tokens.hasMoreThan(2)) {
            throw new RuntimeException("Too many tokens, expected: image <*|element identifier> [key] {");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: image <*|element identifier> [key] {");
        }
        key = tokens.includes(2) ? tokens.get(2) : this.generateViewKey(workspace, VIEW_TYPE);
        this.validateViewKey(key);
        String scopeIdentifier = tokens.get(1);
        if (WILDCARD.equals(scopeIdentifier)) {
            view = workspace.getViews().createImageView(key);
        } else {
            Element element = context.getElement(scopeIdentifier);
            if (element == null) {
                throw new RuntimeException("The element \"" + scopeIdentifier + "\" does not exist");
            }
            view = workspace.getViews().createImageView(element, key);
        }
        return view;
    }
}

