/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.configuration.Role;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;

final class UserRoleParser
extends AbstractParser {
    private static final String GRAMMAR = "<username> <read|write>";
    private static final int USERNAME_INDEX = 0;
    private static final int ROLE_INDEX = 1;

    UserRoleParser() {
    }

    void parse(DslContext context, Tokens tokens) {
        Role role;
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: <username> <read|write>");
        }
        if (tokens.size() != 2) {
            throw new RuntimeException("Expected: <username> <read|write>");
        }
        String username = tokens.get(0);
        String roleAsString = tokens.get(1);
        if (roleAsString.equalsIgnoreCase("write")) {
            role = Role.ReadWrite;
        } else if (roleAsString.equalsIgnoreCase("read")) {
            role = Role.ReadOnly;
        } else {
            throw new RuntimeException("The role should be \"read\" or \"write\"");
        }
        context.getWorkspace().getConfiguration().addUser(username, role);
    }
}

