/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.DslParserContext;
import com.structurizr.dsl.StructurizrDslParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.CreateImpliedRelationshipsUnlessAnyRelationshipExistsStrategy;
import com.structurizr.model.ImpliedRelationshipsStrategy;
import com.structurizr.util.WorkspaceUtils;
import java.io.File;

final class WorkspaceParser
extends AbstractParser {
    private static final String GRAMMAR_STANDALONE = "workspace [name] [description]";
    private static final String GRAMMAR_EXTENDS = "workspace extends <file|url>";
    private static final int FIRST_INDEX = 1;
    private static final int SECOND_INDEX = 2;

    WorkspaceParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Workspace parse(DslParserContext context, Tokens tokens) {
        Workspace workspace = new Workspace("Name", "Description");
        workspace.getModel().setImpliedRelationshipsStrategy((ImpliedRelationshipsStrategy)new CreateImpliedRelationshipsUnlessAnyRelationshipExistsStrategy());
        if (tokens.hasMoreThan(2)) {
            throw new RuntimeException("Too many tokens, expected: workspace [name] [description] or workspace extends <file|url>");
        }
        if (!tokens.includes(1)) return workspace;
        String firstToken = tokens.get(1);
        if ("extends".equals(firstToken)) {
            if (!tokens.includes(2)) throw new RuntimeException("Expected: workspace extends <file|url>");
            String source = tokens.get(2);
            try {
                if (source.startsWith("https://")) {
                    if (source.endsWith(".json")) {
                        String json = this.readFromUrl(source);
                        return WorkspaceUtils.fromJson((String)json);
                    }
                    String dsl = this.readFromUrl(source);
                    StructurizrDslParser structurizrDslParser = new StructurizrDslParser();
                    structurizrDslParser.parse(context, dsl);
                    return structurizrDslParser.getWorkspace();
                }
                if (context.isRestricted()) {
                    throw new RuntimeException("Cannot import workspace from a file when running in restricted mode");
                }
                if (context.getFile() == null) return workspace;
                File file = new File(context.getFile().getParent(), source);
                if (!file.exists()) {
                    throw new RuntimeException(file.getCanonicalPath() + " could not be found");
                }
                if (file.isDirectory()) {
                    throw new RuntimeException(file.getCanonicalPath() + " should be a single file");
                }
                if (source.endsWith(".json")) {
                    return WorkspaceUtils.loadWorkspaceFromJson((File)file);
                }
                StructurizrDslParser structurizrDslParser = new StructurizrDslParser();
                structurizrDslParser.parse(context, file);
                return structurizrDslParser.getWorkspace();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        workspace.setName(firstToken);
        if (!tokens.includes(2)) return workspace;
        workspace.setDescription(tokens.get(2));
        return workspace;
    }

    void parseName(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: name <name>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: name <name>");
        }
        String name = tokens.get(1);
        context.getWorkspace().setName(name);
    }

    void parseDescription(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: description <description>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: description <description>");
        }
        String description = tokens.get(1);
        context.getWorkspace().setDescription(description);
    }
}

