/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.configuration.Visibility;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;

final class ConfigurationParser
extends AbstractParser {
    private static final String GRAMMAR = "visibility <private|public>";
    private static final int FIRST_PROPERTY_INDEX = 1;
    private static final String PRIVATE = "private";
    private static final String PUBLIC = "public";

    ConfigurationParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseVisibility(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: visibility <private|public>");
        }
        if (!tokens.includes(1)) throw new RuntimeException("Expected: visibility <private|public>");
        String visibility = tokens.get(1).toLowerCase();
        if (visibility.equalsIgnoreCase(PRIVATE)) {
            context.getWorkspace().getConfiguration().setVisibility(Visibility.Private);
            return;
        } else {
            if (!visibility.equalsIgnoreCase(PUBLIC)) throw new RuntimeException("The visibility \"" + visibility + "\" is not valid");
            context.getWorkspace().getConfiguration().setVisibility(Visibility.Public);
        }
    }
}

