/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AbstractViewParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.DynamicView;

class DynamicViewParser
extends AbstractViewParser {
    private static final String GRAMMAR = "dynamic <*|software system identifier|container identifier> [key] [description] {";
    private static final String VIEW_TYPE = "Dynamic";
    private static final int SCOPE_IDENTIFIER_INDEX = 1;
    private static final int KEY_INDEX = 2;
    private static final int DESCRIPTION_INDEX = 3;
    private static final String WILDCARD = "*";

    DynamicViewParser() {
    }

    DynamicView parse(DslContext context, Tokens tokens) {
        DynamicView view;
        String scopeIdentifier;
        Workspace workspace = context.getWorkspace();
        String key = "";
        String description = "";
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: dynamic <*|software system identifier|container identifier> [key] [description] {");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: dynamic <*|software system identifier|container identifier> [key] [description] {");
        }
        if (tokens.includes(3)) {
            description = tokens.get(3);
        }
        if (WILDCARD.equals(scopeIdentifier = tokens.get(1))) {
            key = tokens.includes(2) ? tokens.get(2) : workspace.getViews().generateViewKey(VIEW_TYPE);
            this.validateViewKey(key);
            view = workspace.getViews().createDynamicView(key, description);
        } else {
            Element element = context.getElement(scopeIdentifier);
            if (element == null) {
                throw new RuntimeException("The software system or container \"" + scopeIdentifier + "\" does not exist");
            }
            if (element instanceof SoftwareSystem) {
                key = tokens.includes(2) ? tokens.get(2) : workspace.getViews().generateViewKey(VIEW_TYPE);
                this.validateViewKey(key);
                view = workspace.getViews().createDynamicView((SoftwareSystem)element, key, description);
            } else if (element instanceof Container) {
                Container container = (Container)element;
                key = tokens.includes(2) ? tokens.get(2) : workspace.getViews().generateViewKey(VIEW_TYPE);
                this.validateViewKey(key);
                view = workspace.getViews().createDynamicView((Container)element, key, description);
            } else {
                throw new RuntimeException("The element \"" + scopeIdentifier + "\" is not a software system or container");
            }
        }
        view.setExternalBoundariesVisible(true);
        return view;
    }
}

