/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

class ElementGroup
extends Element {
    private static final String STRUCTURIZR_GROUP_SEPARATOR_PROPERTY_NAME = "structurizr.groupSeparator";
    private Element parent;
    private final ElementGroup parentGroup;
    private final String name;
    private final Set<Element> elements = new HashSet<Element>();

    ElementGroup(Model model, String name) {
        this.setModel(model);
        this.name = name;
        this.parentGroup = null;
    }

    ElementGroup(Model model, String name, ElementGroup parentGroup) {
        this.setModel(model);
        String groupSeparator = this.getModel().getProperties().getOrDefault(STRUCTURIZR_GROUP_SEPARATOR_PROPERTY_NAME, "");
        if (StringUtils.isNullOrEmpty((String)groupSeparator)) {
            throw new RuntimeException("To use nested groups, please define a model property named structurizr.groupSeparator");
        }
        this.name = parentGroup.getName() + groupSeparator + name;
        this.parentGroup = parentGroup;
    }

    public String getName() {
        return this.name;
    }

    public String getCanonicalName() {
        return this.name;
    }

    void setParent(Element parent) {
        this.parent = parent;
    }

    public Element getParent() {
        return this.parent;
    }

    public Set<String> getDefaultTags() {
        return null;
    }

    void addElement(Element element) {
        this.elements.add(element);
        if (this.parentGroup != null) {
            this.parentGroup.addElement(element);
        }
    }

    Set<Element> getElements() {
        return new HashSet<Element>(this.elements);
    }
}

