/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.IncludedDslContext;
import com.structurizr.dsl.Tokens;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;

final class IncludeParser
extends AbstractParser {
    private static final String GRAMMAR = "!include <file|directory|url>";
    private static final int SOURCE_INDEX = 1;

    IncludeParser() {
    }

    void parse(IncludedDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: !include <file|directory|url>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: !include <file|directory|url>");
        }
        String source = tokens.get(1);
        if (source.startsWith("https://")) {
            String dsl = this.readFromUrl(source);
            List<String> lines = Arrays.asList(dsl.split("\n"));
            context.addFile(context.getParentFile(), lines);
        } else if (context.getParentFile() != null) {
            File path = new File(context.getParentFile().getParent(), source);
            try {
                if (!path.exists()) {
                    throw new RuntimeException(path.getCanonicalPath() + " could not be found");
                }
                this.readFiles(context, path);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private void readFiles(IncludedDslContext context, File path) throws IOException {
        if (path.isHidden()) {
            return;
        }
        if (path.isDirectory()) {
            Object[] files = path.listFiles();
            if (files != null) {
                Arrays.sort(files);
                for (Object file : files) {
                    this.readFiles(context, (File)file);
                }
            }
        } else {
            context.addFile(path, Files.readAllLines(path.toPath(), StandardCharsets.UTF_8));
        }
    }
}

