/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.ModelViewContentParser;
import com.structurizr.dsl.StaticViewDslContext;
import com.structurizr.dsl.StaticViewExpressionParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.CustomElement;
import com.structurizr.model.Element;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.ElementNotPermittedInViewException;
import com.structurizr.view.ModelView;
import com.structurizr.view.StaticView;

final class StaticViewContentParser
extends ModelViewContentParser {
    private static final int FIRST_IDENTIFIER_INDEX = 1;

    StaticViewContentParser() {
    }

    void parseInclude(StaticViewDslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: include <*|identifier|expression> [*|identifier|expression...]");
        }
        StaticView view = context.getView();
        for (int i = 1; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (token.equals("*") || token.equals("element==*")) {
                view.addDefaultElements();
                continue;
            }
            if (this.isExpression(token)) {
                new StaticViewExpressionParser().parseExpression(token, context).forEach(mi -> this.addModelItemToView((ModelItem)mi, view, null));
                continue;
            }
            new StaticViewExpressionParser().parseIdentifier(token, context).forEach(mi -> this.addModelItemToView((ModelItem)mi, view, token));
        }
    }

    void parseExclude(StaticViewDslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: exclude <identifier|expression> [identifier|expression...]");
        }
        StaticView view = context.getView();
        for (int i = 1; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (this.isExpression(token)) {
                new StaticViewExpressionParser().parseExpression(token, context).forEach(mi -> this.removeModelItemFromView((ModelItem)mi, view));
                continue;
            }
            new StaticViewExpressionParser().parseIdentifier(token, context).forEach(mi -> this.removeModelItemFromView((ModelItem)mi, view));
        }
    }

    private void addModelItemToView(ModelItem modelItem, StaticView view, String identifier) {
        if (modelItem instanceof Element) {
            this.addElementToView((Element)modelItem, view, identifier);
        } else {
            this.addRelationshipToView((Relationship)modelItem, view);
        }
    }

    private void addElementToView(Element element, StaticView view, String identifier) {
        try {
            if (element instanceof CustomElement) {
                view.add((CustomElement)element);
            } else if (element instanceof Person) {
                view.add((Person)element);
            } else if (element instanceof SoftwareSystem) {
                view.add((SoftwareSystem)element);
            } else if (element instanceof Container && view instanceof ContainerView) {
                ((ContainerView)view).add((Container)element);
            } else if (element instanceof Container && view instanceof ComponentView) {
                ((ComponentView)view).add((Container)element);
            } else if (element instanceof Component && view instanceof ComponentView) {
                ((ComponentView)view).add((Component)element);
            } else if (!StringUtils.isNullOrEmpty((String)identifier)) {
                throw new RuntimeException("The element \"" + identifier + "\" can not be added to this type of view");
            }
        }
        catch (ElementNotPermittedInViewException elementNotPermittedInViewException) {
            // empty catch block
        }
    }

    private void removeModelItemFromView(ModelItem modelItem, StaticView view) {
        if (modelItem instanceof Element) {
            this.removeElementFromView((Element)modelItem, view);
        } else {
            this.removeRelationshipFromView((Relationship)modelItem, (ModelView)view);
        }
    }

    private void removeElementFromView(Element element, StaticView view) {
        if (element instanceof CustomElement) {
            view.remove((CustomElement)element);
        } else if (element instanceof Person) {
            view.remove((Person)element);
        } else if (element instanceof SoftwareSystem) {
            view.remove((SoftwareSystem)element);
        } else if (element instanceof Container && view instanceof ContainerView) {
            ((ContainerView)view).remove((Container)element);
        } else if (element instanceof Container && view instanceof ComponentView) {
            ((ComponentView)view).remove((Container)element);
        } else if (element instanceof Component && view instanceof ComponentView) {
            ((ComponentView)view).remove((Component)element);
        }
    }

    private void addRelationshipToView(Relationship relationship, StaticView view) {
        if (view.isElementInView(relationship.getSource()) && view.isElementInView(relationship.getDestination())) {
            view.add(relationship);
        }
    }
}

