/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.ContainerDslContext;
import com.structurizr.dsl.SoftwareSystemDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.SoftwareSystem;

final class ContainerParser
extends AbstractParser {
    private static final String GRAMMAR = "container <name> [description] [technology] [tags]";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TECHNOLOGY_INDEX = 3;
    private static final int TAGS_INDEX = 4;

    ContainerParser() {
    }

    Container parse(SoftwareSystemDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: container <name> [description] [technology] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: container <name> [description] [technology] [tags]");
        }
        SoftwareSystem softwareSystem = context.getSoftwareSystem();
        Container container = null;
        String name = tokens.get(1);
        if (context.isExtendingWorkspace()) {
            container = softwareSystem.getContainerWithName(name);
        }
        if (container == null) {
            container = softwareSystem.addContainer(name);
        }
        if (tokens.includes(2)) {
            String description = tokens.get(2);
            container.setDescription(description);
        }
        if (tokens.includes(3)) {
            String technology = tokens.get(3);
            container.setTechnology(technology);
        }
        if (tokens.includes(4)) {
            String tags = tokens.get(4);
            container.addTags(tags.split(","));
        }
        if (context.hasGroup()) {
            container.setGroup(context.getGroup().getName());
            context.getGroup().addElement((Element)container);
        }
        return container;
    }

    void parseTechnology(ContainerDslContext context, Tokens tokens) {
        int index = 1;
        if (tokens.hasMoreThan(index)) {
            throw new RuntimeException("Too many tokens, expected: technology <technology>");
        }
        if (!tokens.includes(index)) {
            throw new RuntimeException("Expected: technology <technology>");
        }
        String technology = tokens.get(index);
        context.getContainer().setTechnology(technology);
    }
}

