/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.GroupableDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.CustomElement;

final class CustomElementParser
extends AbstractParser {
    private static final String GRAMMAR = "element <name> [metadata] [description] [tags]";
    private static final int NAME_INDEX = 1;
    private static final int METADATA_INDEX = 2;
    private static final int DESCRIPTION_INDEX = 3;
    private static final int TAGS_INDEX = 4;

    CustomElementParser() {
    }

    CustomElement parse(GroupableDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: element <name> [metadata] [description] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: element <name> [metadata] [description] [tags]");
        }
        String name = tokens.get(1);
        String metadata = "";
        if (tokens.includes(2)) {
            metadata = tokens.get(2);
        }
        String description = "";
        if (tokens.includes(3)) {
            description = tokens.get(3);
        }
        CustomElement customElement = context.getWorkspace().getModel().addCustomElement(name, metadata, description);
        if (tokens.includes(4)) {
            String tags = tokens.get(4);
            customElement.addTags(tags.split(","));
        }
        if (context.hasGroup()) {
            customElement.setGroup(context.getGroup().getName());
        }
        return customElement;
    }
}

