/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.ScriptDslContext;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class InlineScriptDslContext
extends ScriptDslContext {
    static final Map<String, String> SUPPORTED_LANGUAGES = new HashMap<String, String>();
    private final String language;
    private final List<String> lines = new ArrayList<String>();

    InlineScriptDslContext(DslContext parentContext, File dslFile, String language) {
        super(parentContext, dslFile);
        this.language = language.toLowerCase();
    }

    void addLine(String line) {
        this.lines.add(line);
    }

    @Override
    void end() {
        try {
            if (!SUPPORTED_LANGUAGES.containsKey(this.language)) {
                throw new RuntimeException("Unsupported scripting language \"" + this.language + "\"");
            }
            String fileExtension = SUPPORTED_LANGUAGES.get(this.language);
            this.run(this, fileExtension, this.lines);
        }
        catch (Exception e) {
            throw new RuntimeException("Error running inline script, caused by " + e.getClass().getName() + ": " + e.getMessage(), e);
        }
    }

    @Override
    protected String[] getPermittedTokens() {
        return new String[0];
    }

    static {
        SUPPORTED_LANGUAGES.put("javascript", "js");
        SUPPORTED_LANGUAGES.put("groovy", "groovy");
        SUPPORTED_LANGUAGES.put("kotlin", "kts");
        SUPPORTED_LANGUAGES.put("ruby", "rb");
    }
}

