/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.BrandingDslContext;
import com.structurizr.dsl.IconUtils;
import com.structurizr.dsl.Tokens;
import com.structurizr.util.ImageUtils;
import com.structurizr.view.Font;
import java.io.File;

final class BrandingParser
extends AbstractParser {
    private static final String LOGO_GRAMMAR = "logo <path|url>";
    private static final String FONT_GRAMMAR = "font <name> [url]";
    private static final int LOGO_FILE_INDEX = 1;
    private static final int FONT_NAME_INDEX = 1;
    private static final int FONT_URL_INDEX = 2;

    BrandingParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseLogo(BrandingDslContext context, Tokens tokens, boolean restricted) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: logo <path|url>");
        }
        if (!tokens.includes(1)) throw new RuntimeException("Expected: logo <path|url>");
        String path = tokens.get(1);
        if (path.startsWith("data:image/") || path.startsWith("https://") || path.startsWith("http://")) {
            if (!IconUtils.isSupported(path)) throw new IllegalArgumentException("Only PNG and JPG URLs and data URIs are supported: " + path);
            context.getWorkspace().getViews().getConfiguration().getBranding().setLogo(path);
            return;
        }
        if (restricted) return;
        File file = new File(context.getFile().getParent(), path);
        if (!file.exists() || file.isDirectory()) throw new RuntimeException(path + " does not exist");
        try {
            String dataUri = ImageUtils.getImageAsDataUri((File)file);
            context.getWorkspace().getViews().getConfiguration().getBranding().setLogo(dataUri);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void parseFont(BrandingDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(2)) {
            throw new RuntimeException("Too many tokens, expected: font <name> [url]");
        }
        if (tokens.includes(2)) {
            String name = tokens.get(1);
            String url = tokens.get(2);
            context.getWorkspace().getViews().getConfiguration().getBranding().setFont(new Font(name, url));
        } else if (tokens.includes(1)) {
            String name = tokens.get(1);
            context.getWorkspace().getViews().getConfiguration().getBranding().setFont(new Font(name));
        } else {
            throw new RuntimeException("Expected: font <name> [url]");
        }
    }
}

