/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AbstractViewParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Element;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ContainerView;

final class ContainerViewParser
extends AbstractViewParser {
    private static final String GRAMMAR = "container <software system identifier> [key] [description] {";
    private static final int SOFTWARE_SYSTEM_IDENTIFIER_INDEX = 1;
    private static final int KEY_INDEX = 2;
    private static final int DESCRIPTION_INDEX = 3;

    ContainerViewParser() {
    }

    ContainerView parse(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: container <software system identifier> [key] [description] {");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: container <software system identifier> [key] [description] {");
        }
        Workspace workspace = context.getWorkspace();
        String key = "";
        String description = "";
        String softwareSystemIdentifier = tokens.get(1);
        Element element = context.getElement(softwareSystemIdentifier);
        if (element == null) {
            throw new RuntimeException("The software system \"" + softwareSystemIdentifier + "\" does not exist");
        }
        if (!(element instanceof SoftwareSystem)) {
            throw new RuntimeException("The element \"" + softwareSystemIdentifier + "\" is not a software system");
        }
        SoftwareSystem softwareSystem = (SoftwareSystem)element;
        if (tokens.includes(2)) {
            key = tokens.get(2);
            this.validateViewKey(key);
        }
        if (tokens.includes(3)) {
            description = tokens.get(3);
        }
        ContainerView view = workspace.getViews().createContainerView(softwareSystem, key, description);
        return view;
    }
}

