/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.ImageViewDslContext;
import com.structurizr.dsl.RemoteContent;
import com.structurizr.dsl.Tokens;
import com.structurizr.importer.diagrams.kroki.KrokiImporter;
import com.structurizr.importer.diagrams.mermaid.MermaidImporter;
import com.structurizr.importer.diagrams.plantuml.PlantUMLImporter;
import com.structurizr.util.ImageUtils;
import com.structurizr.util.Url;
import com.structurizr.view.ImageView;
import java.io.File;

final class ImageViewContentParser
extends AbstractParser {
    private static final String PLANTUML_GRAMMAR = "plantuml <file|url>";
    private static final String MERMAID_GRAMMAR = "mermaid <file|url>";
    private static final String KROKI_GRAMMAR = "kroki <format> <file|url>";
    private static final String IMAGE_GRAMMAR = "image <file|url>";
    private static final int TITLE_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 1;
    private static final int PLANTUML_SOURCE_INDEX = 1;
    private static final int MERMAID_SOURCE_INDEX = 1;
    private static final int KROKI_FORMAT_INDEX = 1;
    private static final int KROKI_SOURCE_INDEX = 2;
    private static final int IMAGE_SOURCE_INDEX = 1;
    private boolean restricted = false;

    ImageViewContentParser(boolean restricted) {
        this.restricted = restricted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parsePlantUML(ImageViewDslContext context, File dslFile, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: plantuml <file|url>");
        }
        ImageView view = context.getView();
        if (view == null) return;
        if (tokens.size() != 2) throw new RuntimeException("Expected: plantuml <file|url>");
        String source = tokens.get(1);
        try {
            if (Url.isUrl((String)source)) {
                RemoteContent content = this.readFromUrl(source);
                new PlantUMLImporter().importDiagram(context.getView(), content.getContent());
                context.getView().setTitle(source.substring(source.lastIndexOf("/") + 1));
                return;
            } else {
                if (this.restricted) return;
                File file = new File(dslFile.getParentFile(), source);
                new PlantUMLImporter().importDiagram(context.getView(), file);
            }
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseMermaid(ImageViewDslContext context, File dslFile, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: mermaid <file|url>");
        }
        ImageView view = context.getView();
        if (view == null) return;
        if (tokens.size() != 2) throw new RuntimeException("Expected: mermaid <file|url>");
        String source = tokens.get(1);
        try {
            if (Url.isUrl((String)source)) {
                RemoteContent content = this.readFromUrl(source);
                new MermaidImporter().importDiagram(context.getView(), content.getContent());
                context.getView().setTitle(source.substring(source.lastIndexOf("/") + 1));
                return;
            } else {
                if (this.restricted) return;
                File file = new File(dslFile.getParentFile(), source);
                new MermaidImporter().importDiagram(context.getView(), file);
            }
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseKroki(ImageViewDslContext context, File dslFile, Tokens tokens) {
        if (tokens.hasMoreThan(2)) {
            throw new RuntimeException("Too many tokens, expected: kroki <format> <file|url>");
        }
        ImageView view = context.getView();
        if (view == null) return;
        if (tokens.size() != 3) throw new RuntimeException("Expected: kroki <format> <file|url>");
        String format = tokens.get(1);
        String source = tokens.get(2);
        try {
            if (Url.isUrl((String)source)) {
                RemoteContent content = this.readFromUrl(source);
                new KrokiImporter().importDiagram(context.getView(), format, content.getContent());
                context.getView().setTitle(source.substring(source.lastIndexOf("/") + 1));
                return;
            } else {
                if (this.restricted) return;
                File file = new File(dslFile.getParentFile(), source);
                new KrokiImporter().importDiagram(context.getView(), format, file);
            }
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseImage(ImageViewDslContext context, File dslFile, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: image <file|url>");
        }
        ImageView view = context.getView();
        if (view == null) return;
        if (tokens.size() != 2) throw new RuntimeException("Expected: image <file|url>");
        String source = tokens.get(1);
        try {
            if (Url.isUrl((String)source)) {
                context.getView().setContent(source);
                context.getView().setTitle(source.substring(source.lastIndexOf("/") + 1));
                return;
            } else {
                if (this.restricted) return;
                File file = new File(dslFile.getParentFile(), source);
                context.getView().setContent(ImageUtils.getImageAsDataUri((File)file));
                context.getView().setTitle(file.getName());
            }
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

