/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.ModelItemDslContext;
import com.structurizr.dsl.StructurizrDslParser;
import com.structurizr.dsl.StructurizrDslScriptContext;
import com.structurizr.dsl.ViewDslContext;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

abstract class ScriptDslContext
extends DslContext {
    private static final String CONTEXT_VARIABLE_NAME = "context";
    private static final String WORKSPACE_VARIABLE_NAME = "workspace";
    private static final String VIEW_VARIABLE_NAME = "view";
    private static final String ELEMENT_VARIABLE_NAME = "element";
    private static final String RELATIONSHIP_VARIABLE_NAME = "relationship";
    private final DslContext parentContext;
    protected final File dslFile;
    private final StructurizrDslParser dslParser;
    private final Map<String, String> parameters = new HashMap<String, String>();

    ScriptDslContext(DslContext parentContext, File dslFile, StructurizrDslParser dslParser) {
        this.parentContext = parentContext;
        this.dslFile = dslFile;
        this.dslParser = dslParser;
    }

    void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    void run(DslContext context, String extension, List<String> lines) throws Exception {
        Bindings bindings;
        StringBuilder script = new StringBuilder();
        for (String line : lines) {
            script.append(line);
            script.append('\n');
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByExtension(extension);
        if (engine != null) {
            bindings = engine.createBindings();
            bindings.put(WORKSPACE_VARIABLE_NAME, (Object)context.getWorkspace());
            if (this.parentContext instanceof ViewDslContext) {
                bindings.put(VIEW_VARIABLE_NAME, (Object)((ViewDslContext)this.parentContext).getView());
            } else if (this.parentContext instanceof ModelItemDslContext) {
                ModelItemDslContext modelItemDslContext = (ModelItemDslContext)this.parentContext;
                if (modelItemDslContext.getModelItem() instanceof Element) {
                    bindings.put(ELEMENT_VARIABLE_NAME, (Object)modelItemDslContext.getModelItem());
                } else if (modelItemDslContext.getModelItem() instanceof Relationship) {
                    bindings.put(RELATIONSHIP_VARIABLE_NAME, (Object)modelItemDslContext.getModelItem());
                }
            }
            StructurizrDslScriptContext scriptContext = new StructurizrDslScriptContext(this.dslParser, this.dslFile, this.getWorkspace(), this.parameters);
            bindings.put(CONTEXT_VARIABLE_NAME, (Object)scriptContext);
            for (String name : this.parameters.keySet()) {
                bindings.put(name, (Object)this.parameters.get(name));
            }
        } else {
            throw new RuntimeException("Could not load a scripting engine for extension \"" + extension + "\"");
        }
        engine.eval(script.toString(), bindings);
    }
}

