/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.configuration.Visibility;
import com.structurizr.configuration.WorkspaceScope;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.Tokens;

final class ConfigurationParser
extends AbstractParser {
    private static final String SCOPE_GRAMMAR = "scope <landscape|softwaresystem|none>";
    private static final String SCOPE_LANDSCAPE = "landscape";
    private static final String SCOPE_SOFTWARE_SYSTEM = "softwaresystem";
    private static final String SCOPE_NONE = "none";
    private static final String VISIBILITY_GRAMMAR = "visibility <private|public>";
    private static final String VISIBILITY_PRIVATE = "private";
    private static final String VISIBILITY_PUBLIC = "public";
    private static final int FIRST_PROPERTY_INDEX = 1;

    ConfigurationParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseScope(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: scope <landscape|softwaresystem|none>");
        }
        if (!tokens.includes(1)) throw new RuntimeException("Expected: scope <landscape|softwaresystem|none>");
        String scope = tokens.get(1).toLowerCase();
        if (scope.equalsIgnoreCase(SCOPE_LANDSCAPE)) {
            context.getWorkspace().getConfiguration().setScope(WorkspaceScope.Landscape);
            return;
        } else if (scope.equalsIgnoreCase(SCOPE_SOFTWARE_SYSTEM)) {
            context.getWorkspace().getConfiguration().setScope(WorkspaceScope.SoftwareSystem);
            return;
        } else {
            if (!scope.equalsIgnoreCase(SCOPE_NONE)) throw new RuntimeException("The scope \"" + scope + "\" is not valid");
            context.getWorkspace().getConfiguration().setScope(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseVisibility(DslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: visibility <private|public>");
        }
        if (!tokens.includes(1)) throw new RuntimeException("Expected: visibility <private|public>");
        String visibility = tokens.get(1).toLowerCase();
        if (visibility.equalsIgnoreCase(VISIBILITY_PRIVATE)) {
            context.getWorkspace().getConfiguration().setVisibility(Visibility.Private);
            return;
        } else {
            if (!visibility.equalsIgnoreCase(VISIBILITY_PUBLIC)) throw new RuntimeException("The visibility \"" + visibility + "\" is not valid");
            context.getWorkspace().getConfiguration().setVisibility(Visibility.Public);
        }
    }
}

