/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.documentation.Documentable;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.ComponentDslContext;
import com.structurizr.dsl.ContainerDslContext;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.SoftwareSystemDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.dsl.WorkspaceDslContext;
import com.structurizr.importer.documentation.DefaultImageImporter;
import com.structurizr.importer.documentation.DocumentationImporter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

final class DecisionsParser
extends AbstractParser {
    private static final Map<String, String> DECISION_IMPORTERS = new HashMap<String, String>();
    private static final String ADRTOOLS_DECISION_IMPORTER = "adrtools";
    private static final String LOG4BRAINS_DECISION_IMPORTER = "log4brains";
    private static final String MADR_DECISION_IMPORTER = "madr";
    private static final String GRAMMAR = "!decisions <path> <type|fqn>";
    private static final int PATH_INDEX = 1;
    private static final int TYPE_OR_FQN_INDEX = 2;

    DecisionsParser() {
    }

    void parse(WorkspaceDslContext context, File dslFile, Tokens tokens) {
        this.parse(context, (Documentable)context.getWorkspace(), dslFile, tokens);
    }

    void parse(SoftwareSystemDslContext context, File dslFile, Tokens tokens) {
        this.parse(context, (Documentable)context.getSoftwareSystem(), dslFile, tokens);
    }

    void parse(ContainerDslContext context, File dslFile, Tokens tokens) {
        this.parse(context, (Documentable)context.getContainer(), dslFile, tokens);
    }

    void parse(ComponentDslContext context, File dslFile, Tokens tokens) {
        this.parse(context, (Documentable)context.getComponent(), dslFile, tokens);
    }

    private void parse(DslContext context, Documentable documentable, File dslFile, Tokens tokens) {
        if (tokens.hasMoreThan(2)) {
            throw new RuntimeException("Too many tokens, expected: !decisions <path> <type|fqn>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: !decisions <path> <type|fqn>");
        }
        String fullyQualifiedClassName = DECISION_IMPORTERS.get(ADRTOOLS_DECISION_IMPORTER);
        if (tokens.includes(2)) {
            String typeOrFullyQualifiedName = tokens.get(2);
            fullyQualifiedClassName = DECISION_IMPORTERS.getOrDefault(typeOrFullyQualifiedName, typeOrFullyQualifiedName);
        }
        if (dslFile != null) {
            File path = new File(dslFile.getParentFile(), tokens.get(1));
            if (!path.exists()) {
                throw new RuntimeException("Documentation path " + path + " does not exist");
            }
            if (!path.isDirectory()) {
                throw new RuntimeException("Documentation path " + path + " is not a directory");
            }
            try {
                Class decisionImporterClass = context.loadClass(fullyQualifiedClassName, dslFile);
                Constructor constructor = decisionImporterClass.getDeclaredConstructor(new Class[0]);
                DocumentationImporter decisionImporter = (DocumentationImporter)constructor.newInstance(new Object[0]);
                decisionImporter.importDocumentation(documentable, path);
                if (!tokens.includes(2)) {
                    DefaultImageImporter imageImporter = new DefaultImageImporter();
                    imageImporter.importDocumentation(documentable, path);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Error importing decisions from " + path.getAbsolutePath() + ": " + fullyQualifiedClassName + " was not found");
            }
            catch (Exception e) {
                throw new RuntimeException("Error importing decisions from " + path.getAbsolutePath() + ": " + e.getMessage());
            }
        }
    }

    static {
        DECISION_IMPORTERS.put(ADRTOOLS_DECISION_IMPORTER, "com.structurizr.importer.documentation.AdrToolsDecisionImporter");
        DECISION_IMPORTERS.put(MADR_DECISION_IMPORTER, "com.structurizr.importer.documentation.MadrDecisionImporter");
        DECISION_IMPORTERS.put(LOG4BRAINS_DECISION_IMPORTER, "com.structurizr.importer.documentation.Log4brainsDecisionImporter");
    }
}

