/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.GroupableDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Element;
import com.structurizr.model.Person;

final class PersonParser
extends AbstractParser {
    private static final String GRAMMAR = "person <name> [description] [tags]";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TAGS_INDEX = 3;

    PersonParser() {
    }

    Person parse(GroupableDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: person <name> [description] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: person <name> [description] [tags]");
        }
        Person person = null;
        String name = tokens.get(1);
        if (context.isExtendingWorkspace()) {
            person = context.getWorkspace().getModel().getPersonWithName(name);
        }
        if (person == null) {
            person = context.getWorkspace().getModel().addPerson(name);
        }
        String description = "";
        if (tokens.includes(2)) {
            description = tokens.get(2);
            person.setDescription(description);
        }
        if (tokens.includes(3)) {
            String tags = tokens.get(3);
            person.addTags(tags.split(","));
        }
        if (context.hasGroup()) {
            person.setGroup(context.getGroup().getName());
            context.getGroup().addElement((Element)person);
        }
        return person;
    }
}

