/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.component.ComponentFinderBuilder;
import com.structurizr.dsl.ContainerDslContext;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.IdentifiersRegister;
import com.structurizr.dsl.StructurizrDslParser;
import com.structurizr.model.Component;
import com.structurizr.model.Element;
import java.util.Set;

final class ComponentFinderDslContext
extends DslContext {
    private final ComponentFinderBuilder componentFinderBuilder = new ComponentFinderBuilder();
    private final StructurizrDslParser dslParser;
    private final ContainerDslContext containerDslContext;

    ComponentFinderDslContext(StructurizrDslParser dslParser, ContainerDslContext containerDslContext) {
        this.dslParser = dslParser;
        this.containerDslContext = containerDslContext;
        this.componentFinderBuilder.forContainer(containerDslContext.getContainer());
    }

    @Override
    protected String[] getPermittedTokens() {
        return new String[]{"classes", "source", "strategy"};
    }

    ContainerDslContext getContainerDslContext() {
        return this.containerDslContext;
    }

    ComponentFinderBuilder getComponentFinderBuilder() {
        return this.componentFinderBuilder;
    }

    @Override
    void end() {
        Set components = this.componentFinderBuilder.build().run();
        for (Component component : components) {
            this.dslParser.registerIdentifier(IdentifiersRegister.toIdentifier(component.getName()), (Element)component);
        }
    }
}

