/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.Archetype;
import com.structurizr.dsl.ComponentDslContext;
import com.structurizr.dsl.ContainerDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Element;

final class ComponentParser
extends AbstractParser {
    private static final String GRAMMAR = "component <name> [description] [technology] [tags]";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TECHNOLOGY_INDEX = 3;
    private static final int TAGS_INDEX = 4;

    ComponentParser() {
    }

    Component parse(ContainerDslContext context, Tokens tokens, Archetype archetype) {
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: component <name> [description] [technology] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: component <name> [description] [technology] [tags]");
        }
        Container container = context.getContainer();
        Component component = null;
        String name = tokens.get(1);
        if (context.isExtendingWorkspace()) {
            component = container.getComponentWithName(name);
        }
        if (component == null) {
            component = container.addComponent(name);
        }
        String description = archetype.getDescription();
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        component.setDescription(description);
        String technology = archetype.getTechnology();
        if (tokens.includes(3)) {
            technology = tokens.get(3);
        }
        component.setTechnology(technology);
        String[] tags = archetype.getTags().toArray(new String[0]);
        if (tokens.includes(4)) {
            tags = tokens.get(4).split(",");
        }
        component.addTags(tags);
        component.addProperties(archetype.getProperties());
        component.addPerspectives(archetype.getPerspectives());
        if (context.hasGroup()) {
            component.setGroup(context.getGroup().getName());
            context.getGroup().addElement((Element)component);
        }
        return component;
    }

    void parseTechnology(ComponentDslContext context, Tokens tokens) {
        int index = 1;
        if (tokens.hasMoreThan(index)) {
            throw new RuntimeException("Too many tokens, expected: technology <technology>");
        }
        if (!tokens.includes(index)) {
            throw new RuntimeException("Expected: technology <technology>");
        }
        String technology = tokens.get(index);
        context.getComponent().setTechnology(technology);
    }
}

