/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.ExpressionParser;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

final class DeploymentViewExpressionParser
extends ExpressionParser {
    DeploymentViewExpressionParser() {
    }

    @Override
    protected Set<Element> evaluateElementTypeExpression(String expr, DslContext context) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        String type = expr.substring("element.type==".length());
        switch (type.toLowerCase()) {
            case "custom": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof CustomElement).forEach(elements::add);
                break;
            }
            case "deploymentnode": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof DeploymentNode).forEach(elements::add);
                break;
            }
            case "infrastructurenode": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof InfrastructureNode).forEach(elements::add);
                break;
            }
            case "softwaresystem": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof SoftwareSystem).forEach(elements::add);
                break;
            }
            case "softwaresysteminstance": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof SoftwareSystemInstance).forEach(elements::add);
                break;
            }
            case "container": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof Container).forEach(elements::add);
                break;
            }
            case "containerinstance": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof ContainerInstance).forEach(elements::add);
                break;
            }
            default: {
                throw new RuntimeException("The element type of \"" + type + "\" is not valid for this view");
            }
        }
        return elements;
    }

    @Override
    protected Set<Element> getElements(String identifier, DslContext context) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        for (Element element : super.getElements(identifier, context)) {
            Set elementInstances;
            if (element instanceof SoftwareSystem) {
                elementInstances = context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof SoftwareSystemInstance).map(e -> (SoftwareSystemInstance)e).filter(ssi -> ssi.getSoftwareSystem().equals(element)).collect(Collectors.toSet());
                elements.addAll(elementInstances);
                continue;
            }
            if (element instanceof Container) {
                elementInstances = context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof ContainerInstance).map(e -> (ContainerInstance)e).filter(ci -> ci.getContainer().equals(element)).collect(Collectors.toSet());
                elements.addAll(elementInstances);
                continue;
            }
            elements.add(element);
        }
        return elements;
    }

    @Override
    protected Set<Element> findAfferentCouplings(Element element) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        elements.addAll(this.findAfferentCouplings(element, CustomElement.class));
        elements.addAll(this.findAfferentCouplings(element, DeploymentNode.class));
        elements.addAll(this.findAfferentCouplings(element, InfrastructureNode.class));
        elements.addAll(this.findAfferentCouplings(element, SoftwareSystemInstance.class));
        elements.addAll(this.findAfferentCouplings(element, ContainerInstance.class));
        return elements;
    }

    @Override
    protected Set<Element> findEfferentCouplings(Element element) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        elements.addAll(this.findEfferentCouplings(element, CustomElement.class));
        elements.addAll(this.findEfferentCouplings(element, DeploymentNode.class));
        elements.addAll(this.findEfferentCouplings(element, InfrastructureNode.class));
        elements.addAll(this.findEfferentCouplings(element, SoftwareSystemInstance.class));
        elements.addAll(this.findEfferentCouplings(element, ContainerInstance.class));
        return elements;
    }
}

